#ifndef	_CLASS_LABEL_H_
#define	_CLASS_LABEL_H_
//vim: ts=8
//   File : class_label.h
//   Creation date : Mon Sep 18 14:21:48 CEST 2000 by Krzysztof Godlewski
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//



#include <qlabel.h>
#include "class_widget.h"

class KviScriptLabelObject : public KviScriptWidgetObject
{
	Q_OBJECT
public:
	KviScriptLabelObject(KviScriptObjectClass * c, KviScriptObject * p, 
		const char * n);
	virtual ~KviScriptLabelObject();

	static void registerSelf();
	static void unregisterSelf();

protected:
	virtual bool init(KviCommand *);

	bool functionSetText(KviCommand *, KviParameterList *, KviStr &);
	bool functionText(KviCommand *, KviParameterList *, KviStr &);
	bool functionMargin(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetMargin(KviCommand *, KviParameterList *, KviStr &);
	bool functionAutoResize(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetAutoResize(KviCommand *, KviParameterList *, KviStr &);
	bool functionAlignment(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetAlignment(KviCommand *, KviParameterList *, KviStr &);
	bool functionClear(KviCommand *, KviParameterList *, KviStr &);
	bool functionFrameStyle(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetFrameStyle(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetImage(KviCommand *, KviParameterList *, KviStr &);
};

#endif	// !_CLASS_LABEL_H_
