//vim: ts=8
//   File : class_checkbox.cpp
//   Creation date : Wed Sep 20 23:01:47 CEST 2000 by Krzysztof Godlewski
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_command.h"
#include "kvi_error.h"
#include "kvi_debug.h"
#include "kvi_scriptobject.h"
#include "kvi_locale.h"

#include "class_checkbox.h"

static KviScriptObjectClass * g_pCheckBoxClass = 0;

static KviScriptObject * checkBoxClassCreateInstance(KviScriptObjectClass * c,
	KviScriptObject * p, const char * n)
{
	return new KviScriptCheckBoxObject(c, p, n);
}

KviScriptCheckBoxObject::KviScriptCheckBoxObject(KviScriptObjectClass * c, \
	KviScriptObject * p, const char * n) : KviScriptButtonObject(c, p, n)
{
}

KviScriptCheckBoxObject::~KviScriptCheckBoxObject()
{
}

/*
	@doc:	checkbox
	@title:
		checkbox class
	@type:
		class
	@short:
		Check box with a text description
	@inherits:
		[class]object[/class]
		[class]button[/class]
	@description:
		This widget provides a check box - it is a kind of a toggle 
		button. It can have two states: on (checked) and off 
		(unchecked).
	@functions:
		!fn: $isChecked()
		Returns '1' if the check box is checked, '0' otherwise.[br]
		See also [classfnc]$setChecked[/classfnc]().
		!fn: $setChecked(<bool>)
		Sets the check box 'checked state' to <bool>.[br]
		See also [classfnc]$isChecked[/classfnc]().
*/

bool KviScriptCheckBoxObject::init(KviCommand *)
{
	setObject(new QCheckBox(parentScriptWidget(), name()), true);
	return true;
}

#define checkBoxFuncReg(__nam, __func) \
        g_pCheckBoxClass->registerFunctionHandler(__nam, \
        (KviScriptObjectFunctionHandlerProc)( \
        KVI_PTR2MEMBER(KviScriptCheckBoxObject::__func)), 0, true);

void KviScriptCheckBoxObject::registerSelf()
{
	KviScriptObjectClass * base = g_pScriptObjectController-> \
		lookupClass("button");
	__range_valid(base);

	g_pCheckBoxClass = new KviScriptObjectClass(base, "checkbox", 
		checkBoxClassCreateInstance, true);

	checkBoxFuncReg("isChecked", functionIsChecked);
	checkBoxFuncReg("setChecked", functionSetChecked);
}

void KviScriptCheckBoxObject::unregisterSelf()
{
	delete g_pCheckBoxClass;
    g_pCheckBoxClass = 0;
}

bool KviScriptCheckBoxObject::functionIsChecked(KviCommand *, KviParameterList *,
	KviStr & b)
{
	if(widget())
		b.append(((QCheckBox *)widget())->isChecked() ? '1' : '0');
	return true;
}

bool KviScriptCheckBoxObject::functionSetChecked(KviCommand *, KviParameterList * p,
	KviStr &)
{
	if(widget())
		((QCheckBox *)widget())->setChecked(p->getBool());
	return true;
}

#include "m_class_checkbox.moc"
