//
//   File : libkvistr.cpp
//   Creation date : Thu Dec 27 2001 17:13:12 GMT by Szymon Stefanek
//
//   This str is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#include "kvi_module.h"
#include "kvi_uparser.h"
#include "kvi_locale.h"
#include "kvi_string.h"
#include "kvi_ircmask.h"

static bool mask_module_fnc_match(KviModule *m,KviCommand *c,KviParameterList * parms,KviStr &buffer)
{

	/*
		@doc: mask.match
		@type:
			function
		@title:
			$mask.match
		@short:
			Matches a mask agains a wildcarded one
		@syntax:
			$mask.match(<wildcard_mask>,<fixed_mask>)
		@description:
			Returns 1 if the <wildcard_mask> matches <fixed_mask> and 0 otherwise.
			<wildcard_mask> can obviously contain wildcards ('*' and '?').
		@example:
			[example]
			[cmd]if[/cmd]($mask.match(*!*@*.linux.it,$0))
				[cmd]op[/cmd] [fnc]$mask.nick[/fnc]($0)
			[/example]
	*/

	KviIrcMask mk1(parms->safeFirstParam());
	KviIrcMask mk2(parms->safeNextParam());
	buffer.append(mk1.matchesFixed(mk2.nick(),mk2.user(),mk2.host()) ? '1' : '0');
	return true;
}


static bool mask_module_fnc_nick(KviModule *m,KviCommand *c,KviParameterList * parms,KviStr &buffer)
{

	/*
		@doc: mask.nick
		@type:
			function
		@title:
			$mask.nick
		@short:
			Returns the nick part of an IRC mask
		@syntax:
			$mask.nick(<mask>)
		@description:
			Returns the nickname part of an IRC mask.
	*/

	KviIrcMask mk(parms->safeFirstParam());
	buffer.append(mk.nick());
	return true;
}

static bool mask_module_fnc_user(KviModule *m,KviCommand *c,KviParameterList * parms,KviStr &buffer)
{

	/*
		@doc: mask.user
		@type:
			function
		@title:
			$mask.user
		@short:
			Returns the username part of an IRC mask
		@syntax:
			$mask.user(<mask>)
		@description:
			Returns the username part of an IRC mask.
	*/

	KviIrcMask mk(parms->safeFirstParam());
	buffer.append(mk.user());
	return true;
}


static bool mask_module_fnc_host(KviModule *m,KviCommand *c,KviParameterList * parms,KviStr &buffer)
{

	/*
		@doc: mask.host
		@type:
			function
		@title:
			$mask.host
		@short:
			Returns the hostname part of an IRC mask
		@syntax:
			$mask.host(<mask>)
		@description:
			Returns the hostname part of an IRC mask.
	*/

	KviIrcMask mk(parms->safeFirstParam());
	buffer.append(mk.host());
	return true;
}


static bool mask_module_fnc_hasnumerichost(KviModule *m,KviCommand *c,KviParameterList * parms,KviStr &buffer)
{

	/*
		@doc: mask.hasnumerichost
		@type:
			function
		@title:
			$mask.hasNumericHost
		@short:
			Checks if a host part of a mask is numeric
		@syntax:
			$mask.hasNumericHost(<mask>)
		@description:
			Returns 1 if the hostname part of the mask is numeric (e.g : unresolved IPV4 or IPV6 address)
	*/

	KviIrcMask mk(parms->safeFirstParam());
	buffer.append(mk.hasNumericHost() ? '1' : '0');
	return true;
}


/*********************************************************************/
//              Module stuff
/********************************************************************/



static bool mask_module_init(KviModule * m)
{
	m->registerFunction("match", mask_module_fnc_match);
	m->registerFunction("nick", mask_module_fnc_nick);
	m->registerFunction("user", mask_module_fnc_user);
	m->registerFunction("host", mask_module_fnc_host);
	m->registerFunction("hasnumerichost", mask_module_fnc_hasnumerichost);

	return true;
}

static bool mask_module_cleanup(KviModule *m)
{
	return true;
}

KVIRC_MODULE(
	"File",                                                 // module name
	"1.0.0",                                                // module version
	"Copyright (C) 2002 Szymon Stefanek (pragma at kvirc dot net)",
	"Mask manipulation functions",
	mask_module_init,
	0,
	0,
	mask_module_cleanup
)
