#ifndef _KVI_DIALOG_H_
#define _KVI_DIALOG_H_
//
//   File : libkvidialog.cpp
//   Creation date : Sat Sep 15 2001 01:13:25 by Szymon Stefanek
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_window.h"
#include "kvi_string.h"
#include "kvi_parameterlist.h"
#include "kvi_filedialog.h"
#include "kvi_imagedialog.h"

#include <qmessagebox.h>
#include <qdialog.h>

class KviScriptCallbackDialog
{
public:
	KviScriptCallbackDialog(KviWindow * pWnd,KviStr &code,KviParameterList * parms);
	~KviScriptCallbackDialog();
protected:
	KviWindow        * m_pWindow;
	KviStr             m_szCode;
	KviParameterList * m_pParams;
public:
	void executeCallback();
};


class KviScriptCallbackMessageBox : public QMessageBox , public KviScriptCallbackDialog
{
	Q_OBJECT
public:
	KviScriptCallbackMessageBox(KviStr &caption,KviStr &text,KviStr &icon,KviStr &b1,KviStr &b2,KviStr &b3,KviParameterList * parms,KviWindow * pWnd,KviStr &code);
	~KviScriptCallbackMessageBox();
protected slots:
	virtual void done(int code);
};

class KviScriptCallbackTextInput : public QDialog , public KviScriptCallbackDialog
{
	Q_OBJECT
public:
	KviScriptCallbackTextInput(KviStr &caption,KviStr &label,KviStr &deftext,KviStr &icon,bool bMultiLine,KviStr &b1,KviStr &b2,KviStr &b3,KviParameterList * parms,KviWindow * pWnd,KviStr &code);
	~KviScriptCallbackTextInput();
protected:
	bool      m_bMultiLine;
	QWidget * m_pEdit;
protected:
	virtual void closeEvent(QCloseEvent *e);
	virtual void showEvent(QShowEvent *e);
protected slots:
	void b1Clicked();
	void b2Clicked();
	void b3Clicked();
	virtual void done(int code);
};

class KviScriptCallbackFileDialog : public KviFileDialog , public KviScriptCallbackDialog
{
	Q_OBJECT
public:
	KviScriptCallbackFileDialog(KviStr &caption,KviStr &initial,KviStr &filter,KviParameterList * parms,KviWindow * pWnd,KviStr &code);
	~KviScriptCallbackFileDialog();
protected slots:
	virtual void done(int code);
};

class KviScriptCallbackImageDialog : public KviImageDialog , public KviScriptCallbackDialog
{
	Q_OBJECT
public:
	KviScriptCallbackImageDialog(KviStr &caption,KviStr &szInitial,int iType,int iMaxSize,KviParameterList * parms,KviWindow * pWnd,KviStr &code);
	~KviScriptCallbackImageDialog();
protected slots:
	virtual void done(int code);
};


#endif //_KVI_DIALOG_H_
