//=============================================================================
//
//   File : kvi_popupmanager.cpp
//   Creation date : Sun Sep 1 2000 16:35:45 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000-2003 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================
#define __KVIRC__
#define _KVI_POPUPMANAGER_CPP_

#include "kvi_popupmanager.h"
#include "kvi_config.h"

KviPopupManager * g_pPopupManager = 0;

KviPopupManager::KviPopupManager()
{
	m_pPopupDict = new QDict<KviPopupMenu>(17,false);
	m_pPopupDict->setAutoDelete(true);
}

KviPopupManager::~KviPopupManager()
{
	delete m_pPopupDict;
}

KviPopupMenu * KviPopupManager::getPopup(const QString & nam)
{
	KviPopupMenu * m = lookupPopup(nam);
	if(!m)
	{
		m = new KviPopupMenu(nam);
		m_pPopupDict->insert(nam,m);
	}
	return m;
}

// FIXME: #warning "A Binary popup would work faster and better here"

void KviPopupManager::save(const QString &filename)
{
	KviConfig cfg(filename,KviConfig::Write);
	cfg.clear();

	QDictIterator<KviPopupMenu> it(*m_pPopupDict);
	while(it.current())
	{
		cfg.setGroup(it.current()->name());
		it.current()->save("",&cfg);
		++it;
	}
}

void KviPopupManager::load(const QString &filename)
{
	m_pPopupDict->clear();
	KviConfig cfg(filename,KviConfig::Read);

	KviConfigIterator it(*(cfg.dict()));

	KviPtrList<QString> l;
	l.setAutoDelete(true);

	while(it.current())
	{
		l.append(new QString(it.currentKey()));
		++it;
	}

	for(QString * s = l.first();s;s = l.next())
	{
		cfg.setGroup(*s);
		KviPopupMenu * m = new KviPopupMenu(*s);
		m->load("",&cfg);
		m_pPopupDict->insert(*s,m);
		//++it;
	}
}
