#ifndef _KVI_EXPRTREE_H_
#define _KVI_EXPRTREE_H_

//
//   File : kvi_exprtree.h
//   Creation date : Sun Feb 28 1999 13:34:46 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"

#include "kvi_qstring.h"

// single string operand evaluates to 1 if the string has data , or to 0 if it is empty

// absolute precedence (~operand part)
#define OP_NOT -3          /* !  */
#define OP_BITNOT -2       /* ~  */
#define OP_NEGATE -1       /* -  */
// high precedence
#define OP_BITAND 0        /* &  */
#define OP_BITOR 1         /* |  */
#define OP_SHR 2           /* >> */
#define OP_SHL 3           /* << */
#define OP_POWER 4         /* ^  */
#define OP_MUL 5           /* *  */
#define OP_DIV 6           /* /  */
#define OP_MOD 7           /* %  */
#define OP_SUB 8           /* -  */
#define OP_ADD 9           /* +  */

#define OP_GT 10           /* >  */
#define OP_LT 11           /* <  */
#define OP_EQ 12           /* == */ /* Case insensitive comparison for strings or normal comp.fr numbers */
#define OP_CSEQ 13         /* @= */ /* Case sensitive compare for strings or normal comp. for numbers */
#define OP_GE 14           /* >= */ 
#define OP_LE 15           /* <= */
#define OP_NE 16           /* != */ /* Case insensitive (normal for numbers) */
#define OP_CSNE 17         /* !@ */ /* Case sensitive (normal for numbers) */

#define OP_AND 18          /* && */
#define OP_OR 19           /* || */
// low precedence

// the operators SUB and ADD have the same precedence!
inline long operator_precedence(long op){ return op == OP_SUB ? OP_ADD : op; };

class KVIRC_API KviExprTree
{
public:
	enum NodeType{ NumericOperand, StringOperand, BinaryOperator, UnaryOperator };
public:
	KviExprTree(NodeType t,long v);
	KviExprTree(const QString &str,long lVal);
	KviExprTree(const QString &string);
	~KviExprTree();
public:
	int      m_type;

	long     m_value;
	QString  m_string;
private:
	KviExprTree * m_left;
	KviExprTree * m_right;
	KviExprTree * m_parent;
public:
	KviExprTree * left(){ return m_left; };
	KviExprTree * right(){ return m_right; };
	void setLeft(KviExprTree * node);
	void setRight(KviExprTree * node);
	long firstBinaryOperator();
	KviExprTree * parentWithPrecedenceLowerThan(long operValue);
	long calculate(KviCommand *c);
};

#endif //!_KVI_EXPRTREE_H_
