//=============================================================================
//
//   File : kvi_kvs_treenode_datalist.cpp
//   Created on Tue 07 Oct 2003 02:03:41 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#define __KVIRC__

#include "kvi_kvs_treenode_datalist.h"
#include "kvi_kvs_runtimecontext.h"

#include "kvi_qstring.h"

KviKvsTreeNodeDataList::KviKvsTreeNodeDataList(const QChar * pLocation)
: KviKvsTreeNode(pLocation)
{
	m_pDataList = new KviPtrList<KviKvsTreeNodeData>();
	m_pDataList->setAutoDelete(true);
}

KviKvsTreeNodeDataList::~KviKvsTreeNodeDataList()
{
	delete m_pDataList;
}

KviKvsTreeNodeData * KviKvsTreeNodeDataList::releaseFirst()
{
	KviKvsTreeNodeData * d = m_pDataList->first();
	if(d)
	{
		m_pDataList->setAutoDelete(false);
		m_pDataList->removeFirst();
		m_pDataList->setAutoDelete(true);
	}
	return d;
}


void KviKvsTreeNodeDataList::dump(const char * prefix)
{
	debug("%s DataList",prefix);
	QString tmp = prefix;
	tmp.append("  ");
	for(KviKvsTreeNodeData * t = m_pDataList->first();t;t = m_pDataList->next())
	{
		t->dump(tmp.latin1());
	}
}

bool KviKvsTreeNodeDataList::evaluate(KviKvsRunTimeContext * c,KviKvsVariantList * pBuffer)
{
	pBuffer->clear();
	for(KviKvsTreeNodeData * t = m_pDataList->first();t;t = m_pDataList->next())
	{
		KviKvsVariant * v = new KviKvsVariant();
		if(!t->evaluateReadOnly(c,v))
		{
			delete v;
			pBuffer->clear();
			return false;
		}
		pBuffer->append(v);
	}
	return true;
}

void KviKvsTreeNodeDataList::addItem(KviKvsTreeNodeData * p)
{
	m_pDataList->append(p);
	p->setParent(this);
}
