//=============================================================================
//
//   File : kvi_kvs_treenode_baseobjectfunctioncall.cpp
//   Created on Tue 07 Oct 2003 03:30:10 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#define __KVIRC__

#include "kvi_kvs_treenode_baseobjectfunctioncall.h"

KviKvsTreeNodeBaseObjectFunctionCall::KviKvsTreeNodeBaseObjectFunctionCall(const QChar * pLocation,const QString &szBaseClass,const QString &szFncName,KviKvsTreeNodeDataList * pParams)
: KviKvsTreeNodeObjectFunctionCall(pLocation,szFncName,pParams)
{
	m_szBaseClass = szBaseClass;
}

KviKvsTreeNodeBaseObjectFunctionCall::~KviKvsTreeNodeBaseObjectFunctionCall()
{
}


void KviKvsTreeNodeBaseObjectFunctionCall::dump(const char * prefix)
{
	debug("%s BaseObjectFunctionCall(%s::%s)",prefix,m_szBaseClass.latin1(),m_szFunctionName.latin1());
	QString tmp = prefix;
	tmp.append("  ");
	m_pParams->dump(tmp.latin1());
}

