#ifndef _KVI_KVS_SWITCHLIST_H_
#define _KVI_KVS_SWITCHLIST_H_
//=============================================================================
//
//   File : kvi_kvs_switchlist.h
//   Created on Mon 27 Oct 2003 03:47:48 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#include "kvi_settings.h"
#include "kvi_qstring.h"
#include "kvi_kvs_variant.h"

#include <qintdict.h>
#include <qdict.h>

class KVIRC_API KviKvsSwitchList
{
public:
	KviKvsSwitchList();
	~KviKvsSwitchList();
protected:
	QIntDict<KviKvsVariant> * m_pShortSwitchDict;
	QDict<KviKvsVariant>    * m_pLongSwitchDict;
public:
	void clear();
	void addShort(int iShortKey,KviKvsVariant * pVariant);
	void addLong(const QString &szLongKey,KviKvsVariant * pVariant);

	bool isEmpty(){ return ((m_pShortSwitchDict == 0) && (m_pLongSwitchDict == 0)); };

	KviKvsVariant * find(int iShortKey)
	{
		return m_pShortSwitchDict ? m_pShortSwitchDict->find(iShortKey) : 0;
	};
	KviKvsVariant * find(int iShortKey,const QString &szLongKey)
	{
		if(m_pLongSwitchDict)
		{
			KviKvsVariant * t;
			t = m_pLongSwitchDict->find(szLongKey);
			if(t)return t;
		}
		return m_pShortSwitchDict ? m_pShortSwitchDict->find(iShortKey) : 0;
	};

	bool get(int iKey,QString &szBuffer);
	bool get(int iKey,int iBuffer);
};

#endif //!_KVI_KVS_SWITCHLIST_H_
