#ifndef _KVI_KVS_REPORT_H_
#define _KVI_KVS_REPORT_H_
//=============================================================================
//
//   File : kvi_kvs_report.h
//   Creation date : Thu 25 Sep 2003 05.12 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2003 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#include "kvi_settings.h"
#include "kvi_qstring.h"

class KVIRC_API KviKvsReport
{
public:
	enum Type { /*Information ,*/ Warning , Error }; // error is critical : warning may be recoverable
public:
	// iErrorLocation may be negative : in this case no location is specified
	KviKvsReport(Type t,const QChar * pLocation,const QString &szDescription);
	~KviKvsReport();
private:
	Type           m_type;
	QString        m_szDescription;
	const QChar  * m_pLocation;
public:
	Type type() const { return m_type; };
	// returns the description of the report
	const QString & description() const { return m_szDescription; };
	// returns the character of the buffer where the report was triggered
	// the char may be negative: in this case no location is specified
	const QChar * location() const { return m_pLocation; };
};


#endif //!_KVI_KVS_REPORT_H_
