//=============================================================================
//
//   File : kvi_kvs_coresimplecommands_sz.cpp
//   Created on Fri 31 Oct 2003 00:04:25 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#define __KVIRC__

#include "kvi_kvs_coresimplecommands.h"

#include "kvi_ircconnection.h"
#include "kvi_console.h"

namespace KviKvsCoreSimpleCommands
{

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	/*
		@doc: whois
		@type:
			command
		@title:
			whois
		@syntax:
			whois [server] <nickname>
		@short:
			Requests user information
		@description:
			Requests information about an irc user specified by <nickname>.[br]
			If [server] is specified, the request is directed to that one. [server]
			may be a nickname so that the request is redirected to the server that
			the user with that nickname is connected to.[br]
			An useful trick is to use the following syntax:[br]
			whois <nickname> <nickname>[br]
			This will requests information about the user <nickname> to the server that he is currently
			connected to; returning the idle time among the other common information.[br]
			This command is [doc:connection_dependant_commands]connection dependant[/doc].
		@examples:
			[example]
			[comment]# Query info about Pragma[/comment]
			whois Pragma
			[comment]# Get the Pragma idle time[/comment]
			whois Pragma Pragma
			[/example]
		@seealso:
			[cmd]whowas[/cmd]
	*/
	
	_KVS_CORESIMPLECOMMAND(whois)
	{
		QString all;
		pParams->allAsString(all);

		QCString szData = c->window()->encodeText(all);
		if(szData.isEmpty())return c->warningMissingParameter();

		if(!c->connection())return c->warningNoIrcConnection();
		if(!c->connection()->sendFmtData("WHOIS %s",szData.data()))return c->warningNoIrcConnection();
		return true;
	}
	
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	/*
		@doc: whowas
		@type:
			command
		@title:
			whowas
		@syntax:
			whowas <nickname>
		@short:
			Requests user information
		@description:
			Requests information about an irc user specified by <nickname>.[br]
			Whowas requests "history" records. See [doc:rfc2812]RFC2812[/doc] for more info.[br]
			This command is [doc:connection_dependant_commands]connection dependant[/doc].
		@examples:
			[example]
			[comment]# Query past info about Pragma[/comment]
			whowas Pragma
			[/example]
		@seealso:
			[cmd]whois[/cmd]
	*/
	
	_KVS_CORESIMPLECOMMAND(whowas)
	{
		QString all;
		pParams->allAsString(all);

		QCString szData = c->window()->encodeText(all);
		if(szData.isEmpty())return c->warningMissingParameter();

		if(!c->connection())return c->warningNoIrcConnection();
		if(!c->connection()->sendFmtData("WHOWAS %s",szData.data()))return c->warningNoIrcConnection();
		return true;
	}
};
