//=============================================================================
//
//   File : kvi_kvs_corefunctions_sz.cpp
//   Created on Fri 31 Oct 2003 01:52:04 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#define __KVIRC__

#include "kvi_kvs_corefunctions.h"

#include "kvi_kvs_kernel.h"


#include "kvi_window.h"
#include "kvi_out.h"
#include "kvi_locale.h"
#include "kvi_app.h"
#include "kvi_options.h"

namespace KviKvsCoreFunctions
{


	/*
		@doc: sw
		@type:
			function
		@title:
			$sw
		@short:
			Returns the value of a switch for an alias
		@syntax:
			$sw(<letter>)
		@description:
			This function is valid and useful only in aliases.
			It allows an alias to handle switches just like any other
			KVIrc command. If a switch in the form -<letter> was
			passed to the current alias then $sw(<letter>) 
			returns 1 (true). If a switch in the form -<letter>=<value>
			was passed to the current alias then <value> is returned.
			If the switch was not present at all then this function
			returns an empty string (that evaluates to false in an expression).
			A warning is printed if this function is used non-alias code.
		@examples:
			alias(test){
				if($sw(a))echo "Switch -a was passed"
				%x = $sw(x);
				if(%x)echo "Switch -x=%x was passed"
			}
			test -a
			test -x
			test -a -x
			test -a -x=test
			test -a=10 -x=test
	*/

	_KVS_COREFUNCTION(sw)
	{
		KviKvsSwitchList * sl = c->aliasSwitchList();
		if(!sl)
		{
			c->warning(__tr2qs("The $sw() function can be used only in aliases"));
			return true;
		}
		if(pParams->count())
		{
			QString szLetter;
			if(pParams->firstAsString(szLetter))
			{
				if(szLetter.length() > 0)
				{
					KviKvsVariant * v = sl->find(szLetter[0].unicode());
					if(v)pRetBuffer->copyFrom(*v);
					else pRetBuffer->setNothing();
					return true;
				}
			}
		}

		c->warning(__tr2qs("$sw expects a switch letter as parameter"));
		return true;
	}

	//////////////////////////////////////////////////////////////////////////////

	/*
 		@doc: window
 		@type:
 			function
		@title:
			$window
		@short:
			Retrieve the id of a specified window.
		@syntax:
			$window
			$window(<caption text>)
		@description:
			Returns the [b]window id[/b] of the first window that
			has the specified <caption text>.[br]
			If no window matches the specified <caption text>, and invalid
			window id is returned (0).[br]
			If no <caption text> is specified , this function returns the id
			of the current window.[br]
		@examples:
 			[example]
 				[cmd]echo[/cmd] This is the window with id $window
			[/example]
		@seealso:
			[fnc]$channel[/fnc],
 			[fnc]$query[/fnc],
			[fnc]$console[/fnc],
			[doc:window_naming_conventions]Window naming conventions[/doc]
	*/
 
 
 	_KVS_COREFUNCTION(window)
 	{
		//#warning "FIXME: the window identifiers could be numbers!"
		KviWindow * wnd = c->window();
		if(pParams->count())
		{
			QString szCaption;
			if(pParams->firstAsString(szCaption))
			{
				wnd = g_pApp->findWindowByCaption(szCaption);
				if(!wnd)
				{
					c->warning(__tr2qs("Window with caption %Q not found"),&szCaption);
					return true;
				}
			}
		}
		pRetBuffer->setString(QString(wnd->id()));
		return true;
	}
};

