#ifndef _KVI_KVS_COREFUNCTIONS_H_
#define _KVI_KVS_COREFUNCTIONS_H_
//=============================================================================
//
//   File : kvi_kvs_corefunctions.h
//   Created on Fri 31 Oct 2003 01:52:04 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#include "kvi_settings.h"
#include "kvi_kvs_runtimecontext.h"
#include "kvi_kvs_variantlist.h"
#include "kvi_kvs_variant.h"

#define _KVS_COREFUNCTION(_name) bool _name(KviKvsRunTimeContext * c,KviKvsVariantList * pParams,KviKvsVariant * pRetBuffer)

namespace KviKvsCoreFunctions
{
	// a_f
	_KVS_COREFUNCTION(array);
	// g_l
	_KVS_COREFUNCTION(hash);

	_KVS_COREFUNCTION(isEmpty);
	_KVS_COREFUNCTION(isNumeric);
	_KVS_COREFUNCTION(isSet);
	_KVS_COREFUNCTION(isTimer);
	
	_KVS_COREFUNCTION(keys);

	// m_r
	
	// s_z
	_KVS_COREFUNCTION(sw);
	_KVS_COREFUNCTION(window);

	void init();
};

#endif //!_KVI_KVS_COREFUNCTIONS_H_
