#ifndef _KVI_IRCCONNECTIONSERVERINFO_H_
#define _KVI_IRCCONNECTIONSERVERINFO_H_
//=============================================================================
//
//   File : kvi_ircconnectionserverinfo.h
//   Created on Tue 22 Jun 2004 03:57:32 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2004 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#include "kvi_settings.h"
#include "kvi_qstring.h"

#define KVI_NUM_POSSIBLE_MODE_PREFIX_CHARS 128

class KVIRC_API KviIrcConnectionServerInfo
{
	friend class KviConsole; // for now
	friend class KviServerParser;
	friend class KviIrcConnection;
protected:
	KviIrcConnectionServerInfo();
	~KviIrcConnectionServerInfo();
private:
	QString m_szName;                      // the most actual server name (may be the one we specify or the one that the server wants to be known as)
	QString m_szSupportedUserModes;        // the supported user modes
	QString m_szSupportedChannelModes;     // the supported channel modes
	QString m_szSupportedModePrefixes;     // the actually used mode prefixes  @+
	unsigned char m_cModePrefixTable[KVI_NUM_POSSIBLE_MODE_PREFIX_CHARS]; // the mode prefixes above in a table
	QString m_szSupportedModeFlags;        // the actually used mode flags     ov
	QString m_szSupportedChannelTypes;     // the supported channel types
	bool m_bSupportsModesIe;               // supports the channel modes I and e ?
	bool m_bSupportsWatchList;             // supports the watch list ?
	bool m_bSupportsCodePages;             // supports the /CODEPAGE command ?
public:
	const QString & name(){ return m_szName; };
	const QString & supportedUserModes(){ return m_szSupportedUserModes; };
	const QString & supportedChannelModes(){ return m_szSupportedChannelModes; };
	const QString & supportedChannelTypes(){ return m_szSupportedChannelTypes; };
	const QString & supportedModePrefixes(){ return m_szSupportedModePrefixes; };
	const QString & supportedModeFlags(){ return m_szSupportedModeFlags; };
	bool supportsModesIe(){ return m_bSupportsModesIe; };
	bool supportsWatchList(){ return m_bSupportsWatchList; };
	bool supportsCodePages(){ return m_bSupportsCodePages; };
	bool isSupportedModePrefix(unsigned char c){ return (c < KVI_NUM_POSSIBLE_MODE_PREFIX_CHARS) ? (m_cModePrefixTable[c] != 0) : false; };
protected:
	void setName(const QString &szName){ m_szName = szName; };
	void setSupportedUserModes(const QString &szSupportedUserModes){ m_szSupportedUserModes = szSupportedUserModes; };
	void setSupportedModeFlags(const QString &szSupportedModeFlags){ m_szSupportedModeFlags = szSupportedModeFlags; };
	void setSupportedChannelModes(const QString &szSupportedChannelModes);
	void setSupportedModePrefixes(const QString &szSupportedModePrefixes);
	void setSupportedChannelTypes(const QString &szSupportedChannelTypes){ m_szSupportedChannelTypes = szSupportedChannelTypes; };
	void setSupportsWatchList(bool bSupportsWatchList){ m_bSupportsWatchList = bSupportsWatchList; };
	void setSupportsCodePages(bool bSupportsCodePages){ m_bSupportsCodePages = bSupportsCodePages; };
private:
	void buildModePrefixTable();
};

#endif //!_KVI_IRCCONNECTIONSERVERINFO_H_
