// =============================================================================
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Andrea Parrella (anandrea@iname.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviUrlBanFrame"

#define _KVI_URL_BANFRAME_CPP_

#include <qcheckbox.h>
#include <qlayout.h>

#ifdef QT_NO_ASCII_CAST
	#undef QT_NO_ASCII_CAST
#endif

#define __KVIRC_PLUGIN__

#include "kvi_lineeditdialog.h"
#include "kvi_listbox.h"
#include "kvi_locale.h"
#include "kvi_pushbutton.h"
#include "kvi_url.h"
#include "kvi_url_banframe.h"
#include "kvirc_plugin.h"

/**
 * KviUrlBanFrame.
 */
KviUrlBanFrame::KviUrlBanFrame(QWidget *parent, const char *name, bool banEnabled)
	: QFrame(parent, name)
{
	setFrameStyle(QFrame::Panel | QFrame::Raised);

	QGridLayout *g = new QGridLayout(this, 2, 2, 10, 10);

	m_pEnable = new QCheckBox(__tr("Enable URL ban list"), this);
	connect(m_pEnable, SIGNAL(clicked()), this, SLOT(enableClicked()));
	m_pEnable->setChecked(banEnabled);
	g->addMultiCellWidget(m_pEnable, 0, 0, 0, 1);

	m_pBanList = new KviListBox(this, "listbox");
	m_pBanList->setMinimumHeight(100);
	loadBanList();
	for( KviStr *tmp = g_pBanList->first(); tmp; tmp = g_pBanList->next() )
		m_pBanList->insertItem(tmp->ptr()); // Load ban list into listbox
	m_pBanList->setEnabled(m_pEnable->isChecked());
	g->addMultiCellWidget(m_pBanList, 1, 1, 0, 1);

	m_pAddBtn = new KviPushButton(__tr("Add ban"), this, "add");
	connect(m_pAddBtn, SIGNAL(clicked()), this, SLOT(addBan()));
	m_pAddBtn->setEnabled(m_pEnable->isChecked());
	g->addWidget(m_pAddBtn, 2, 0);

	m_pRemoveBtn = new KviPushButton(__tr("Remove selected"), this, "remove");
	connect(m_pRemoveBtn, SIGNAL(clicked()), this, SLOT(removeBan()));
	m_pRemoveBtn->setEnabled(m_pEnable->isChecked());
	g->addWidget(m_pRemoveBtn, 2, 1);
}

void KviUrlBanFrame::enableClicked()
{
	  m_pBanList->setEnabled(m_pEnable->isChecked());
	   m_pAddBtn->setEnabled(m_pEnable->isChecked());
	m_pRemoveBtn->setEnabled(m_pEnable->isChecked());
}

void KviUrlBanFrame::addBan()
{
	bool ok = false;
	KviStr *text = new KviStr(KviLineEditDialog::getText(__tr("URL ban list"), __tr("Add"), QString::null, &ok, this));
	if( ok && !text->isEmpty() ) {
		g_pBanList->append(text);
		m_pBanList->insertItem(text->ptr());
	}
}

void KviUrlBanFrame::removeBan()
{
	uint i = 0;
	while( (!m_pBanList->isSelected(i)) && (i < m_pBanList->count()) )
		i++;
	if( !m_pBanList->isSelected(i) ) {
		kvirc_plugin_warning_box(__tr("Select a ban"));
		return;
	}
	KviStr item(m_pBanList->text(i).latin1());
	for(KviStr *tmp = g_pBanList->first(); tmp; tmp = g_pBanList->next() ) {
		if( *tmp == item ) g_pBanList->remove();
	}

	m_pBanList->removeItem(i);
}

void KviUrlBanFrame::saveBans()
{
	if( m_pEnable->isChecked() ) saveBanList();
	KviConfig *cfg = new KviConfig(g_configPath.ptr());
	cfg->setGroup("ConfigDialog");
	cfg->writeEntry("BanEnabled", m_pEnable->isChecked());
	delete cfg;
}

KviUrlBanFrame::~KviUrlBanFrame()
{
	// Nothing here
}

#include "m_kvi_url_banframe.moc"
