// =============================================================================
//
//      --- kvi_options_ctcp_multimedia.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviOptionsCtcpMultimedia"

#include <qlayout.h>

#include "kvi_boolselector.h"
#include "kvi_fileselector.h"
#include "kvi_locale.h"
#include "kvi_options_ctcp_multimedia.h"
#include "kvi_options.h"

/*
	@quickhelp: KviOptionsCtcpMultimedia
	@widget: CTCP multimedia (sound) options
		In this page you can setup the CTCP MULTIMEDIA requests handling.<br>
		You will find more information in the <a href="doc_ctcp_multimedia.kvihelp">"CTCP multimedia protocol"</a> document.<br>
*/
KviOptionsCtcpMultimedia::KviOptionsCtcpMultimedia(QWidget *parent)
	: KviOptionsWidget(parent, KVI_GENERAL_OPTIONS_WIDGET_ID_CTCPMULTIMEDIA)
{
	QGridLayout *g = new QGridLayout(
		this, 8, 1, KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER, KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE
	);

	KviBoolSelector *b1 = new KviBoolSelector(this,
		__tr("Enable processing for CTCP MULTIMEDIA (SOUND)"), &(g_pOptions->m_bListenToCtcpMultimedia)
	);
	g->addWidget(b1, 0, 0);

	QFrame *f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addWidget(f, 1, 0);

	KviBoolSelector *b = new KviBoolSelector(this,
		__tr("Play the following file when requested file is not found:"),
		&(g_pOptions->m_bPlayDefaultFileWhenFileNotFound), g_pOptions->m_bListenToCtcpMultimedia
	);
	connect(b1, SIGNAL(toggled(bool)), b, SLOT(setEnabled(bool)));
	g->addWidget(b, 2, 0);

	KviFileSelector *fs = new KviFileSelector(this,
		&(g_pOptions->m_szCtcpMultimediaDefaultFileName), true, g_pOptions->m_bPlayDefaultFileWhenFileNotFound
	);
	connect(b, SIGNAL(toggled(bool)), fs, SLOT(setEnabled(bool)));
	g->addWidget(fs, 3, 0);

	f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addWidget(f, 4, 0);

	b = new KviBoolSelector(this,
		__tr("Send \"!nick <filename>\" privmsg request when file is not found"),
		&(g_pOptions->m_bSendMultimediaRequestWhenFileNotFound), g_pOptions->m_bListenToCtcpMultimedia
	);
	connect(b1, SIGNAL(toggled(bool)), b, SLOT(setEnabled(bool)));
	g->addWidget(b, 5, 0);

	b = new KviBoolSelector(this,
		__tr("Accept \"!nick <filename>\" privmsg requests"), &(g_pOptions->m_bListenToMultimediaFileRequests)
	);
	g->addWidget(b, 6, 0);

	// Trick
	f = new QFrame(this);
	g->addWidget(f, 7, 0);
	g->setRowStretch(7, 1);
}

KviOptionsCtcpMultimedia::~KviOptionsCtcpMultimedia()
{
	// Nothing here
}

void KviOptionsCtcpMultimedia::commitChanges()
{
	KviBoolSelector::commitAll(this);
	commitFileSelectors();
}

#include "m_kvi_options_ctcp_multimedia.moc"
