// =============================================================================
//
//      --- kvi_options_ctcp_messages.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviOptionsCtcpMessages"

#include <qlayout.h>

#include "kvi_boolselector.h"
#include "kvi_locale.h"
#include "kvi_options_ctcp_messages.h"
#include "kvi_options.h"
#include "kvi_settings.h"
#include "kvi_stringselector.h"

/*
	@quickhelp: KviOptionsCtcpMessages
	@widget: CTCP text messages
		Here you can set the default text strings that will be sent to the
		remote clients in the CTCP messages when you specify no replacement.<br>
		The postfixes are strings that will be APPENDED to the default replies.<br>
*/
KviOptionsCtcpMessages::KviOptionsCtcpMessages(QWidget *parent)
	: KviOptionsWidget(parent, KVI_GENERAL_OPTIONS_WIDGET_ID_CTCPMESSAGES)
{
	QGridLayout *g = new QGridLayout(
		this, 10, 1, KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER, KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE
	);

	KviStringSelector *s = new KviStringSelector(this,
		__tr("VERSION reply postfix:"), &(g_pOptions->m_szCtcpVersionAppendix)
	);
	g->addWidget(s, 0, 0);
	s = new KviStringSelector(this, __tr("USERINFO reply postfix:"), &(g_pOptions->m_szCtcpUserinfoAppendix));
	g->addWidget(s, 1, 0);
	s = new KviStringSelector(this, __tr("CLIENTINFO reply postfix:"), &(g_pOptions->m_szCtcpClientinfoAppendix));
	g->addWidget(s, 2, 0);
	s = new KviStringSelector(this, __tr("SOURCE reply postfix:"), &(g_pOptions->m_szCtcpSourceAppendix));
	g->addWidget(s, 3, 0);
	s = new KviStringSelector(this, __tr("FINGER reply:"), &(g_pOptions->m_szCtcpFingerReply));
	g->addWidget(s, 4, 0);

	QFrame *f = new QFrame(this);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addWidget(f, 5, 0);

	KviBoolSelector *b = new KviBoolSelector(this,
		__tr("Append real username to the USERINFO reply"), &(g_pOptions->m_bAppendRealUsernameToUserinfoReply)
	);
	g->addWidget(b, 6, 0);

#if defined(HAVE_SYS_UTSNAME_H) && defined(HAVE_UNAME)
	b = new KviBoolSelector(this,
		__tr("Append system info (uname) to the CLIENTINFO reply"), &(g_pOptions->m_bAppendUnameToClientinfoReply)
	);
#else
	b = new KviBoolSelector(this,
		__tr("Append system info (uname) to the CLIENTINFO reply"), &(g_pOptions->m_bAppendUnameToClientinfoReply), false
	);
#endif
	g->addWidget(b, 7, 0);

	b = new KviBoolSelector(this,
		__tr("Reply CTCP ERRMSG to unknown CTCP requests"), &(g_pOptions->m_bReplyErrmsgOnUnknownCtcp)
	);
	g->addWidget(b, 8, 0);

	// Trick
	f = new QFrame(this);
	g->addWidget(f, 9, 0);
	g->setRowStretch(9, 1);
}

KviOptionsCtcpMessages::~KviOptionsCtcpMessages()
{
	// Nothing here
}

void KviOptionsCtcpMessages::commitChanges()
{
	KviStringSelector::commitAll(this);
	KviBoolSelector::commitAll(this);
}

#include "m_kvi_options_ctcp_messages.moc"
