// =============================================================================
//
//      --- kvi_dcc_sendmessagebox.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviDccSendMessageBox"

#include "kvi_application.h"
#include "kvi_dcc_manager.h"
#include "kvi_dcc_send_event.h"
#include "kvi_dcc_sendmessagebox.h"
#include "kvi_frame.h"
#include "kvi_locale.h"
#include "kvi_netutils.h"

// NOTE: uAddress in this file is in NETWORK BYTE ORDER.

KviDccSendMessageBox::KviDccSendMessageBox(KviFrame *parent, KviDccSendRequestData *data)
	: KviMessageBox(
		_CHAR_2_QSTRING(__tr("DCC Send Request")), _CHAR_2_QSTRING(""),
		NoIcon,
		Yes | Default,
		No  | Escape,
		0, parent, 0, false
	  )
{
	m_pData = data;

	struct in_addr addr;
	addr.s_addr = data->uAddress;
	KviStr humanReadableAddr;

	kvi_binaryIpToString(addr, humanReadableAddr);

	KviStr tmp(KviStr::Format,
		__tr(
			"%s [%s@%s]\n"\
			"wants to send you a file named\n"\
			"%s, size %u bytes.\n"\
			"The remote DCC target host is %s on port %u\n"\
			"Do you wish to accept?"
		),
		data->nick.ptr(), data->username.ptr(), data->host.ptr(),
		data->fileName.ptr(), data->fileLength, humanReadableAddr.ptr(), data->uPort
	);
	setText(_CHAR_2_QSTRING(tmp.ptr()));
}

KviDccSendMessageBox::~KviDccSendMessageBox()
{
	if( m_pData ) {
		delete m_pData;
		m_pData = 0;
	}
}

void KviDccSendMessageBox::done(int result)
{
	KviMessageBox::done(result);
	if( !m_pData ) return;

	if( result == Yes ) {
		KviDccSendEvent *ev = new KviDccSendEvent(m_pData);
		KviApplication::postEvent(m_pData->parent, ev);
		m_pData = 0;
	}
}

#include "m_kvi_dcc_sendmessagebox.moc"
