#ifndef _KVI_TOOLBAR_QT_H_INCLUDED_
#define _KVI_TOOLBAR_QT_H_INCLUDED_

// =============================================================================
//
//      --- kvi_toolbar_qt.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qintdict.h>
#include <qtoolbar.h>

class QLineEdit;
class QToolButton;

class KviPopupMenu;
class KviMainWindow;

class KviToolBar : public QToolBar
{
	Q_OBJECT
public:
	KviToolBar(
		const QString &, KviMainWindow *, QWidget *, Qt::Dock dock = Qt::DockTop, bool nl = false, const char *name = 0
	);
	~KviToolBar();

	void insertLineSeparator();
    int insertButton(
		const QString &icon, int id, const char *signal, QObject *receiver, const char *slot,
		bool enabled = true, const QString &text = QString::null, const QString &tooltip = QString::null
	);
	int insertLined(
		const QString &text, int id, const char *signal, const QObject *receiver, const char *slot,
		bool enabled = true, const QString &toolTipText = QString::null, int size = 70, int index = -1
	);

	void setPreferOwnIcons(bool);
	void setItemAutoSized(int, bool yes = true);
	void setItemEnabled(int, bool);
	void setToggle(int, bool yes = true);
	void setButton(int, bool);
	void setDelayedPopup(int, KviPopupMenu *);

	QToolButton *getButton(int);
	QString getLinedText(int) const;

	void setButtonIcon(int, const QString &);
	void setButtonText(int, const QString &, bool tipToo = false);

	void toggleBigIcons(bool);
	void toggleIconText(bool);
private:
	QIntDict<QToolButton> m_buttons;
	QIntDict<QLineEdit>   m_lineedits;
};

#endif // _KVI_TOOLBAR_QT_H_INCLUDED_
