// =============================================================================
//
//      --- kvi_colorbutton_qt.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviColorButton"

#include <qpainter.h>

#include "kvi_colorbutton_qt.h"
#include "kvi_colordialog.h"

KviColorButton::KviColorButton(QWidget *parent, const QColor &color)
	: KviPushButton(parent)
{
	setColor(color);
	connect(this, SIGNAL(clicked()), this, SLOT(slot_buttonClicked()));
}

KviColorButton::~KviColorButton()
{
	// Nothing here
}

void KviColorButton::slot_buttonClicked()
{
	QColor sel = m_color;
	if( kvi_selectColor(sel) )
		setColor(sel);
	// else: cancelled
}

void KviColorButton::setColor(const QColor &color)
{
	m_color = color;
	update();
}

const QColor KviColorButton::color()
{
	return m_color;
}

void KviColorButton::drawButtonLabel(QPainter *paint)
{
	paint->setPen(isEnabled() ? QColor(0, 0, 0) : QColor(120, 120, 120));
	paint->drawRect(3, 3, width() - 6, height() - 6);
	if( isEnabled() )
		paint->fillRect(4, 4, width() - 8, height() - 8, m_color);
}

#include "m_kvi_colorbutton_qt.moc"
