using System;
using Gtk;
using GtkExtra;

namespace Kurush
{

[TreeNode(ColumnCount=(int) Columns.Count)]
public class SummaryNode : TreeNode
{
    public enum Columns
    {
        Name,
        Description,
        Balance,
        Weight,
        Count
    }

    private Data.Group group = null;
    private Data.Account account = null;

    public Data.Account Account
    {
        get
        {
            return account;
        }
    }

    public Data.Group Group
    {
        get
        {
            return group;
        }
    }

    [TreeNodeValue(Column= (int) Columns.Name)]
    public string Name
    {
        get
        {
            if (account != null)
                return account.Name;
            else
                return group.Name;
        }
    }

    [TreeNodeValue(Column=(int) Columns.Description)]
    public string Description
    {
        get
        {
            if (account != null)
                return account.Description;
            else
                return "";
        }
    }

    [TreeNodeValue(Column=(int) Columns.Balance)]
    public string Balance
    {
        get
        {
            if (account != null)
                return Format.Value (account.GroupBalance);
            else
                return Format.Value (group.Balance);
        }
    }

    [TreeNodeValue(Column=(int) Columns.Weight)]
    public int Weight
    {
        get
        {
            if (account != null)
                return (int) Pango.Weight.Normal;
            else
                return (int) Pango.Weight.Bold;
        }
    }

    public SummaryNode (Data.Account account)
    {
        this.account = account;
    }

    public SummaryNode (Data.Group group)
    {
        this.group = group;
    }


}

}
