using System;
using System.Runtime.InteropServices;
using Gtk;

namespace GtkExtra
{

public class TreeViewEx : TreeView
{
    static GLib.GType gtype = GLib.GType.Invalid;
    public static new GLib.GType GType
    {
        get
        {
            if (gtype == GLib.GType.Invalid)
                gtype = RegisterGType (typeof (TreeViewEx));
            return gtype;
        }
    }

    private NodeStore store;

    public event EventHandler DoubleClicked;

    public TreeViewEx (NodeStore store) : base (GType)
    {
        this.store = store;

        gtk_tree_view_set_model (Handle, store.Handle);
    }

    public ITreeNode GetSelected ()
    {
        return GetSelectedRow (store, Selection);
    }

    [DllImport("libgtk-win32-2.0-0.dll")]
    static extern IntPtr gtk_tree_view_set_model (IntPtr raw, IntPtr raw_model);

    [DllImport("libgtk-win32-2.0-0.dll")]
    static extern bool gtk_tree_selection_get_selected(IntPtr raw, out IntPtr model, out Gtk.TreeIter iter);

    private bool GetSelected(TreeSelection selection, out Gtk.TreeIter iter)
    {
        IntPtr model_handle;
        bool raw_ret = gtk_tree_selection_get_selected(selection.Handle, out model_handle, out iter);
        bool ret = raw_ret;
        return ret;
    }

    [DllImport("libgtk-win32-2.0-0.dll")]
    static extern IntPtr gtk_tree_model_get_path(IntPtr raw, ref Gtk.TreeIter iter);

    private Gtk.TreePath GetPath(NodeStore store, Gtk.TreeIter iter)
    {
        IntPtr raw_ret = gtk_tree_model_get_path(store.Handle, ref iter);
        Gtk.TreePath ret = new Gtk.TreePath(raw_ret);
        if (ret == null)
            ret = new Gtk.TreePath(raw_ret);
        return ret;
    }


    private ITreeNode GetSelectedRow (NodeStore store, TreeSelection selection)
    {
        TreeIter iter;
        if (GetSelected (selection, out iter))
        {
            TreePath path = GetPath (store, iter);
            return store.GetNode (path);
        }
        else
            return null;
    }

    private void ToggleSelected ()
    {
        TreeIter iter;
        if (GetSelected (Selection, out iter))
        {
            TreePath path = GetPath (store, iter);
            if (!ExpandRow (path, false))
                CollapseRow (path);
        }
    }

    private ITreeNode node;
    public Menu ContextMenu;

    protected override bool OnButtonPressEvent (Gdk.EventButton evnt)
    {
        if (evnt.Type == Gdk.EventType.ButtonPress)
        {
            if (evnt.Button == 1)
                node = GetSelected ();
            else if (evnt.Button == 3)
            {
                if (ContextMenu != null)
                    ContextMenu.Popup (null, null, null, IntPtr.Zero,
                                       evnt.Button, evnt.Time);
            }
        }
        else if (evnt.Type == Gdk.EventType.TwoButtonPress)
        {
            if (evnt.Button == 1 && node == GetSelected ())
            {
                if (DoubleClicked != null)
                    DoubleClicked (this, null);
            }
        }

        base.OnButtonPressEvent (evnt);

        return true;
    }

}

}
