using System;
using Gtk;


namespace GtkExtra
{

public abstract class ManagedEntry
{
    protected Entry entry;

    private bool numeric;
    private TextDirection direction;

    public bool HasFocus
    {
        get
        {
            return entry.HasFocus;
        }
        set
        {
            entry.HasFocus = value;
        }
    }

    public ManagedEntry (Entry entry, bool numeric)
    {
        this.entry = entry;
        this.numeric = numeric;

        if (Entry.DefaultDirection == TextDirection.Rtl)
            this.direction = TextDirection.Ltr;
        else
            this.direction = TextDirection.Rtl;

        Update ();

        entry.FocusInEvent += new FocusInEventHandler (EntryFocusInEvent);
        entry.FocusOutEvent += new FocusOutEventHandler (EntryFocusOutEvent);
        Format.Info.Changed += new EventHandler (FormatChanged);
    }

    protected abstract void FormatEntry ();
    protected abstract void ParseValue ();

    protected virtual void UnFormatEntry ()
    {
    }

    protected void Update ()
    {
        FormatEntry ();

        if (numeric)
            entry.Direction = direction;
    }

    private void FormatChanged (object obj, EventArgs args)
    {
        FormatEntry ();
    }

    private void EntryFocusInEvent (object o, FocusInEventArgs args)
    {
        if (numeric)
        {
            UnFormatEntry ();
            entry.Direction = Entry.DefaultDirection;
        }
    }

    private void EntryFocusOutEvent (object o, FocusOutEventArgs args)
    {
        if (entry.Text != "")
        {
            try
            {
                ParseValue ();
            }
            catch (Exception e)
            {
            }
        }

        Update ();
    }

}



}
