using System;
using System.Globalization;
using System.Xml.Serialization;
using System.Xml.Schema;

namespace GtkExtra
{

public class FormatInfo
{
    [XmlIgnore] public NumberFormatInfo NumberProvider;
    [XmlIgnore] public DateTimeFormatInfo DateProvider;
    public event EventHandler Changed;

    [XmlAttribute] public string ShortDatePattern
    {
        get
        {
            return DateProvider.ShortDatePattern;
        }
        set
        {
            DateProvider.ShortDatePattern = value;
            OnChange ();
        }
    }

    [XmlAttribute] public string DateSeparator
    {
        get
        {
            return DateProvider.DateSeparator;
        }
        set
        {
            DateProvider.DateSeparator = value;
            OnChange ();
        }
    }

    [XmlAttribute] public int DecimalDigits
    {
        get
        {
            return NumberProvider.NumberDecimalDigits;
        }
        set
        {
            NumberProvider.NumberDecimalDigits = value;
            OnChange ();
        }
    }

    [XmlAttribute] public int NumberNegativePattern
    {
        get
        {
            return NumberProvider.NumberNegativePattern;
        }
        set
        {
            NumberProvider.NumberNegativePattern = value;
            OnChange ();
        }
    }

    private void OnChange ()
    {
        if (Changed != null)
            Changed (this, new EventArgs ());
    }

    public FormatInfo ()
    {
        DateProvider = new DateTimeFormatInfo ();
        NumberProvider = new NumberFormatInfo ();

        DecimalDigits = 2;
        NumberNegativePattern = 0;
    }
}

}
