using System;
using Gtk;

namespace GtkExtra
{

public class DateTimeEntry : ManagedEntry
{
    private DateTime val = DateTime.Today;

    public DateTime Value
    {
        get
        {
            return this.val;
        }
        set
        {
            this.val = value;
            Update ();
        }
    }

    public DateTimeEntry (Entry entry) : base (entry, false)
    {
    }

    protected override void FormatEntry ()
    {
        entry.Text = Format.Value (val);
    }

    protected override void ParseValue ()
    {
        val = DateTime.Parse (entry.Text, Format.Info.DateProvider);
    }
}

}
