using System;
using Gtk;
using Glade;

namespace Kurush
{

public class DateDialog : TopLevel
{
    [Glade.Widget] private VBox fromVBox;
    [Glade.Widget] private Calendar fromCalendar;
    [Glade.Widget] private Calendar toCalendar;

    public DateDialog (Window parent, bool showBegDate) : base ("dateDialog", parent)
    {
        fromVBox.Visible = showBegDate;
        Self.Show ();
    }

    public DateTime BeginningDate
    {
        get
        {
            return fromCalendar.GetDate ();
        }
        set
        {
            fromCalendar.SelectMonth ( (uint) value.Month - 1, (uint) value.Year);
            fromCalendar.SelectDay ( (uint) value.Day);
        }
    }

    public DateTime EndingDate
    {
        get
        {
            return toCalendar.GetDate ();
        }
        set
        {
            toCalendar.SelectMonth ( (uint) value.Month - 1, (uint) value.Year);
            toCalendar.SelectDay ( (uint) value.Day);
        }
    }

}

}
