/***************************************************************************
                          qocrprogress.h  -  description
                             -------------------
    begin                : Tue Jan 16 2001
    copyright            : (C) 2001 by Michael Herder
    email                : crapsite@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2 as     *
 *   published by the Free Software Foundation.                            *
 *                                                                         *
 ***************************************************************************/

#ifndef QOCRPROGRESS_H
#define QOCRPROGRESS_H

//#include <qdialog.h>
#include <qimage.h>
#include <qobject.h>
#include <qstring.h>
#include <kprocio.h>

/**
  *@author Michael Herder
  */
class KProcess;
class KTempFile;

class QOCRProgress : public QObject
{
Q_OBJECT
public:
	QOCRProgress(QObject *parent=0);
	~QOCRProgress();
  /**  */
  QString ocrText();
  bool isRunning() { return m_process && m_process->isRunning(); }
  /** No descriptions */
//  void setImagePath(QString path);
  /** No descriptions */
  void start(QImage image);
  /** Write property of int m_dustSize. */
  virtual void setDustSize( const int& _newVal);
  /** Write property of int m_greyLimit. */
  virtual void setGreyLimit( const int& _newVal);
protected: // Protected methods
  /**  */
  QString m_ocrText;
  /**  */
  KProcIO* m_process;//mpOcrProcess;
  /** Parameter for gocr. 0 is *strongly* recommended. */
  int m_dustSize;
  /** Parameter for gocr. 160-180 should work, defaults to 180. */
  int m_greyLimit;
  KTempFile *tempImageFile;
  /**  */
  void startOCR();
  bool unrecognized_characters;
protected slots: // Protected slots
  /** */
  void slotReceivedStderr(KProcess *, char *buffer, int buflen);
  /**  */
  void slotProcessExited();
  /**  */
  void slotReadStdout();
signals:
  void finishedOCR(QString ocrResult);
};

#endif
