/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _PARENT_LOG_LINE_H_
#define _PARENT_LOG_LINE_H_

//Qt includes
#include <qobject.h>

//KDE includes
#include <kurl.h>

#include "globals.h"

#include "logLine.h"
#include "logViewColumn.h"
#include "logViewColumns.h"


/**
 * @author Nicolas Ternisien
 */
class ParentLogLine : public LogLine {
	
	public:
		ParentLogLine(
			QDate& date, QTime& time, QStringList& list, QString& originalFile, LogLevel* level, int tpe,
			groupByType group, int column, LogViewColumns* cols
		);

		virtual ~ParentLogLine();

		void addChild(LogLine* child);
		void removeChild(LogLine* child);
		
		bool isChild(LogLine* child);
		bool hasChildren();
		
		groupByType getGroupBy();
		int getGroupByColumn();
		LogViewColumns* getColumns();
		
		virtual bool isParentLogLine();
		
		static int getGroupedColumnIndex(LogViewColumns* columns, int column);
		
	protected:
		QPtrList<LogLine> children;
		
		groupByType groupBy;
		int groupByColumn;
		LogViewColumns* columns;
};

#endif
