/***************************************************************************
 *   Copyright (C) 2004 by Stefan Kombrink                                 *
 *   katakombi@web.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <klocale.h>
#include <kglobal.h>
#include <kparts/genericfactory.h>

#include "ksynaptics.h"
#include "ksdlg.h"
#include "synparam.h"
#include "myframe.h"
#include "ksdlg.h"

#include <qlayout.h>
#include <qwidget.h>
//#include <qpainter.h>
//#include <qcolor.h>
#include <qlabel.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <qlistbox.h>
#include <qcombobox.h>
#include <qlabel.h>
//#include <qcursor.h>
#include <qevent.h>

#include <kled.h>
#include <kcombobox.h>

#include <kdebug.h>

typedef KGenericFactory<ksynaptics, QWidget> ksynapticsFactory;
K_EXPORT_COMPONENT_FACTORY( kcm_ksynaptics, ksynapticsFactory("kcm_ksynaptics"))

//! for initializing on KDE start-up
extern "C" 
{ 
    KCModule *init_UserSettings(QWidget *, const char *)
    {
        // do initialization here
        SynTouchPad myTp;

        myTp.readConfig();
        myTp.applyConfig();

        // ready :)
        return NULL;
    };
}


ksynaptics::ksynaptics(QWidget *parent, const char *name, const QStringList&)
    : KCModule(ksynapticsFactory::instance(), parent, name)
{
    setButtons(Default|Apply);

    // place widgets here
    QBoxLayout * l = new QHBoxLayout(this);

    myDlg  = new ksDlg(this);
    l->add(myDlg);

    myAboutData =
        new KAboutData(I18N_NOOP("ksynaptics"), I18N_NOOP("setting up the synaptics touch pad"),
                "0.1", I18N_NOOP("This kcmodule is based on the X11 Synaptics Driver (http://w1.894.telia.com/~u89404340/touchpad/)"),
                KAboutData::License_GPL,
                "(c) 2004 by Stefan Kombrink",
                0,"http://qsynaptics.sourceforge.net");

    myAboutData->addAuthor("Stefan Kombrink", "http://qsynaptics.sourceforge.net", "katakombi@web.de");

    // connections (display dependancies)
    connect(myDlg->generalSwitchBG, SIGNAL(clicked(int)), this, SLOT(depTouchPad(int)));
    connect(myDlg->scrollingEmulationBG, SIGNAL(clicked(int)), this, SLOT(depScrollMode(int)));
    connect(myDlg->scrollingNormalHorizCB, SIGNAL(toggled(bool)), this, SLOT(depScrollHoriz(bool)));
    connect(myDlg->scrollingNormalVertCB, SIGNAL(toggled(bool)), this, SLOT(depScrollVert(bool)));
    connect(myDlg->tappingEmulationCB, SIGNAL(toggled(bool)), this, SLOT(depTapping(bool)));
    connect(myDlg->tappingSmartModeCB, SIGNAL(toggled(bool)), this, SLOT(depTapSmart(bool)));
    connect(myDlg->tappingButtonFingerCoB, SIGNAL(highlighted(int)), this, SLOT(depMultiFinger(int)));

    // connections (update settings)
    connect(myDlg->generalSwitchBG, SIGNAL(clicked(int)), this, SLOT(updateTouchPad(int)));
    connect(myDlg->scrollingEmulationBG, SIGNAL(clicked(int)), this, SLOT(updateScrollMode(int)));
    connect(myDlg->scrollingNormalHorizCB, SIGNAL(toggled(bool)), this, SLOT(updateScrollHoriz(bool)));
    connect(myDlg->scrollingNormalVertCB, SIGNAL(toggled(bool)), this, SLOT(updateScrollVert(bool)));
    connect(myDlg->tappingEmulationCB, SIGNAL(toggled(bool)), this, SLOT(updateTapping(bool)));
    connect(myDlg->tappingSmartModeCB, SIGNAL(toggled(bool)), this, SLOT(updateTapSmart(bool)));
    connect(myDlg->tappingButtonBG, SIGNAL(clicked(int)), this, SLOT(updateMultiFinger(int)));

    connect(myDlg->scrollingNormalHSpeedS, SIGNAL(valueChanged(int)), this, SLOT(updateHSS(int)));
    connect(myDlg->scrollingNormalVSpeedS, SIGNAL(valueChanged(int)), this, SLOT(updateVSS(int)));
    connect(myDlg->scrollingCircularSpeedS, SIGNAL(valueChanged(int)), this, SLOT(updateCSS(int)));
    connect(myDlg->tappingEmulationTimeS, SIGNAL(valueChanged(int)), this, SLOT(updateTT(int)));
    connect(myDlg->tappingSmartModeDelayS, SIGNAL(valueChanged(int)), this, SLOT(updateSMD(int)));
    connect(myDlg->generalSensitivityS, SIGNAL(valueChanged(int)), this, SLOT(updatePS(int)));
    connect(myDlg->scrollingCircularCornerCoB, SIGNAL(highlighted(int)), myDlg->cornerEdgeFrame, SLOT(displayCSEdges(int)));

    myDlg->cornerEdgeFrame->setMouseTracking(TRUE);

    load();

    // this is important to be AFTER load()
    // otherwise the restored value is overwritten with a wrong one!
    // however, this is a bad thing, therefore a FIXME
    connect(myDlg->scrollingCircularCornerCoB, SIGNAL(highlighted(int)), this, SLOT(updateEdges(int)));
};


ksynaptics::~ksynaptics()
{
    myTp.cancelConfig();
}

void ksynaptics::disableFunctionality()
{
    myDlg->generalSensitivityGB->setDisabled(TRUE);
    myDlg->scrollingEmulationBG->setDisabled(TRUE);
    myDlg->scrollingNormalGB->setDisabled(TRUE);
    myDlg->scrollingCircularGB->setDisabled(TRUE);
    myDlg->tappingEmulationGB->setDisabled(TRUE);
    myDlg->tappingSmartModeGB->setDisabled(TRUE);
    myDlg->tappingButtonConfigGB->setDisabled(TRUE);

    // enable this widget if driver is available
    myDlg->generalSwitchBG->setEnabled(myTp.hasSynaptics()); 
}



void ksynaptics::enableFunctionality()
{
    myDlg->generalSensitivityGB->setEnabled(TRUE);
    myDlg->tappingEmulationGB->setEnabled(TRUE);
    myDlg->scrollingEmulationBG->setEnabled(TRUE);

    myDlg->tappingButtonConfigGB->setEnabled(TRUE);

    if (myTp.hasSynDaemon())
    {
        // only allow smart mode when syndaemon is available
        myDlg->tappingSmartModeGB->setEnabled(TRUE);
        myDlg->tappingSmartModeCB->setEnabled(TRUE);
    }
}

void ksynaptics::depTouchPad(int state)
{
    if (!state)
        enableFunctionality();
    else
        disableFunctionality();
}

void ksynaptics::depScrollMode(int state)
{
    switch (state)
    {
        case 0:
            myDlg->scrollingNormalGB->setDisabled(TRUE); 
            myDlg->scrollingCircularGB->setDisabled(TRUE);
            break;
        case 1:
            myDlg->scrollingNormalGB->setEnabled(TRUE);
            myDlg->scrollingCircularGB->setDisabled(TRUE);
            break;
        case 2:
            myDlg->scrollingNormalGB->setDisabled(TRUE);
            myDlg->scrollingCircularGB->setEnabled(TRUE);
            break;
        default:break;
    }
}

void ksynaptics::depScrollHoriz(bool on)
{
    myDlg->scrollingNormalHSpeedS->setEnabled(on);
    myDlg->fast1TL->setEnabled(on);
    myDlg->slow1TL->setEnabled(on);
}

void ksynaptics::depScrollVert(bool on)
{
    myDlg->scrollingNormalVSpeedS->setEnabled(on);
    myDlg->fast2TL->setEnabled(on);
    myDlg->slow2TL->setEnabled(on);
}


void ksynaptics::depTapping(bool on)
{
    myDlg->tappingSmartModeGB->setEnabled(on);
    myDlg->tappingButtonConfigGB->setEnabled(on);
    myDlg->tappingEmulationTimeS->setEnabled(on);
    myDlg->tappingTimeTL->setEnabled(on);
    myDlg->short1TL->setEnabled(on);
    myDlg->long1TL->setEnabled(on);
}

void ksynaptics::depTapSmart(bool on)
{
    myDlg->tappingDelayTL->setEnabled(on);
    myDlg->tappingSmartModeDelayS->setEnabled(on);
    myDlg->short2TL->setEnabled(on);
    myDlg->long2TL->setEnabled(on);
}

void ksynaptics::depMultiFinger(int finger)
{
    // don't proceed with more than three fingers
    if (finger > 2) return;

    switch (myFinger[finger])
    {
        case 0: myDlg->tappingButtonNoneRB->setChecked(TRUE); break;
        case 1: myDlg->tappingButtonLeftRB->setChecked(TRUE); break;
        case 2: myDlg->tappingButtonRightRB->setChecked(TRUE); break;
        case 3: myDlg->tappingButtonMiddleRB->setChecked(TRUE); break;
        default: break;
    }
}


void ksynaptics::updateTouchPad(int state)
{
    if (!state)
        myTp.setParameter(TOUCHPADOFF, 0);
    else
        myTp.setParameter(TOUCHPADOFF, 1);

    emit changed(myTp.settingsChanged());
}

void ksynaptics::updateScrollMode(int state)
{
    myTp.setParameter(SCROLLINGMODE, state);
    emit changed(myTp.settingsChanged());
}

void ksynaptics::updateScrollHoriz(bool on)
{
    myTp.setParameter(HSCROLLEMUOFF, !on);
    emit changed(myTp.settingsChanged());
}

void ksynaptics::updateScrollVert(bool on)
{
    myTp.setParameter(VSCROLLEMUOFF, !on);
    emit changed(myTp.settingsChanged());
}

void ksynaptics::updateTapping(bool on)
{
    myTp.setParameter(TAPPINGOFF, !on);
    emit changed(myTp.settingsChanged());
}

void ksynaptics::updateTapSmart(bool on)
{
    myTp.setParameter(SYNDAEMONOFF, !on);
    emit changed(myTp.settingsChanged());
}

void ksynaptics::updateMultiFinger(int finger) 
{
    switch(myDlg->tappingButtonFingerCoB->currentItem())
    {
        case 0: myTp.setParameter(TAPBUTTON1, finger); break;
        case 1: myTp.setParameter(TAPBUTTON2, finger); break;
        case 2: myTp.setParameter(TAPBUTTON3, finger); break;
        default: break;
    }
    emit changed(myTp.settingsChanged());
}



void ksynaptics::updateHSS(int d) 
{ myTp.setParameter(HORIZSCROLLDELTA, d); emit changed(myTp.settingsChanged()); }

void ksynaptics::updateVSS(int d) 
{ myTp.setParameter(VERTSCROLLDELTA, d); emit changed(myTp.settingsChanged()); }

void ksynaptics::updateCSS(int d) 
{ myTp.setParameter(CIRCSCROLLDELTA, d); emit changed(myTp.settingsChanged()); }

void ksynaptics::updateTT(int t) 
{ myTp.setParameter(MAXTAPTIME, t); emit changed(myTp.settingsChanged()); }

void ksynaptics::updateSMD(int t) 
{ myTp.setParameter(SYNDAEMONTIMING, t); emit changed(myTp.settingsChanged()); }

void ksynaptics::updatePS(int s)
{ myTp.setParameter(PRESSURESENSITIVITY, s); emit changed(myTp.settingsChanged()); }

void ksynaptics::updateEdges(int e)
{ myTp.setParameter(CIRCSCROLLTRIGGER, e); emit changed(myTp.settingsChanged()); }



void ksynaptics::displayConfig()
{
    //
    // touch pad enabled?
    //

    bool tpEnabled = (myTp.getParameter(TOUCHPADOFF) == 0);

    if (tpEnabled)
        myDlg->generalSwitchOnRB->setChecked(TRUE);
    else
        myDlg->generalSwitchOffRB->setChecked(TRUE);

    //
    // scrolling emulation?
    //
    int hScrollD,vScrollD;

    vScrollD = myTp.getParameter(VERTSCROLLDELTA);
    hScrollD = myTp.getParameter(HORIZSCROLLDELTA);

    myDlg->scrollingNormalHSpeedS->setValue(hScrollD);
    myDlg->scrollingNormalVSpeedS->setValue(vScrollD);

    bool hSc = (myTp.getParameter(VSCROLLEMUOFF) == 0);
    bool vSc = (myTp.getParameter(HSCROLLEMUOFF) == 0);

    myDlg->scrollingNormalVertCB->setChecked(hSc);
    myDlg->scrollingNormalHorizCB->setChecked(vSc);

    int cScrollSpeed = (myTp.getParameter(CIRCSCROLLDELTA));

    myDlg->scrollingCircularSpeedS->setValue(cScrollSpeed);
    myDlg->tappingEmulationTimeS->setValue(myTp.getParameter(MAXTAPTIME));

    bool tappingEmu = (myTp.getParameter(TAPPINGOFF) == 0);

    myDlg->tappingEmulationCB->setChecked(tappingEmu);

    int scMode = myTp.getParameter(SCROLLINGMODE);

    // FIXME:
    // don't know why I have to update the scroll mode explicitly
    // there is a connection for that already, but it shows no effect!
    //
    switch(scMode)
    {
        case 0: myDlg->scrollingEmulationOffRB->setChecked(TRUE); 
                depScrollMode(0);
                break;
        case 1: myDlg->scrollingEmulationNormalRB->setChecked(TRUE); 
                depScrollMode(1);
                break;
        case 2: myDlg->scrollingEmulationCircularRB->setChecked(TRUE);
                depScrollMode(2);
                break;
        default: break;
    }

    //
    // smart mode?
    // 
    bool tappingSmartMode = FALSE;

    if (myTp.hasSynDaemon())
    {
        // check the smart mode CB if syndaemon is enabled
        myDlg->tappingSmartModeCB->setChecked(myTp.getParameter(SYNDAEMONOFF) == 0);
        tappingSmartMode = (myTp.getParameter(SYNDAEMONOFF) == 0);

        // set slider
        myDlg->tappingSmartModeDelayS->setValue(myTp.getParameter(SYNDAEMONTIMING));
    }

    //
    // circular trigger (edges / corners)
    //
    int cScrTrigger = myTp.getParameter(CIRCSCROLLTRIGGER);
    myDlg->scrollingCircularCornerCoB->setCurrentItem(cScrTrigger);

    //
    // multifinger button emulation (read values)
    //
    // read new values
    myFinger[0] = (unsigned int)myTp.getParameter(TAPBUTTON1);
    myFinger[1] = (unsigned int)myTp.getParameter(TAPBUTTON2);
    myFinger[2] = (unsigned int)myTp.getParameter(TAPBUTTON3);

    // display the updated value
    depMultiFinger(myDlg->tappingButtonFingerCoB->currentItem());

    // display the current pressure sensitivity
    myDlg->generalSensitivityS->setValue(myTp.getParameter(PRESSURESENSITIVITY));
}



void ksynaptics::load()
{
    kdDebug() <<  "load()" << endl;

    // read user settings if available
    myTp.readConfig();

    disableFunctionality();

    // resize to the fittest
    myDlg->updateGeometry();

    // checks on synaptics touch pad driver
    if (myTp.hasSynaptics()) {
        myDlg->synDriverInfoTL->setText("<b>good</b> - driver is installed!");
        myDlg->synDriverkL->setColor(QColor("Green"));
        myDlg->synapticsDriverVersionTL->setText(myTp.detectSynapticsVersion());

        if (myTp.hasSHMConfigurability())
        {
            myDlg->shMemInfoTL->setText("<b>good</b> - X shared memory accessible!");
            myDlg->shMemInfokL->setColor(QColor("Green"));

            // enable all functionality except the touch pad is disabled on purpose
            if (myTp.getParameter(TOUCHPADOFF) == 0)
                enableFunctionality();

            // display the current state of parameters
            displayConfig();
        }
    }
    else
        myDlg->synapticsDriverVersionTL->setText("<b>none</b>");
}


void ksynaptics::defaults()
{
    myTp.defaultConfig();
    displayConfig();
    emit changed(myTp.settingsChanged());
}


void ksynaptics::save()
{
    myTp.applyConfig();
    emit changed(FALSE);
}

int ksynaptics::buttons()
{
    return KCModule::Default|KCModule::Apply|KCModule::Help;
}


QString ksynaptics::quickHelp() const
{
    return i18n("This module helps you to use several advanced features of your synaptics touch pad.<br>");
}

#include "ksynaptics.moc"
