/***************************************************************************
                          csubtitle.h  -  description
                             -------------------
    begin                : di feb 4 2003
    copyright            : (C) 2003 by Tom Deblauwe
    email                : tom.deblauwe@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CSUBTITLE_H
#define CSUBTITLE_H

#include <qdatetime.h>
#include <qstring.h>

/**Contains information about one subtitle
  *@author Tom Deblauwe
  */

class CSubtitle {
  private:
    long startTime; //in ms
    long endTime;   //in ms
    QString line1;
    QString line2;
  public:
	  CSubtitle(long startTime, long endTime, QString line1, QString line2);
	  CSubtitle(const CSubtitle &);
  	~CSubtitle();
    long getStartTime(void) const;
    long getEndTime(void) const;
    QTime getStartTime_QTime(void) const;
    QTime getEndTime_QTime(void) const;

    QString getLine1(void) const;
    QString getLine2(void) const;
    void setStartTime(long startTime);
    void setEndTime(long endTime);
    void setText(QString line1, QString line2);

    bool operator==(const CSubtitle &);
    bool operator<(const CSubtitle &);
        
};

#endif
