/***************************************************************************
 *   Copyright (C) 2004 by Manuel Prez Lpez                              *
 *   mapelo@ieduca.net                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "sociometrictest.h"
#include "config.h"
#include <math.h> // para el sqrt (en algunas distros no encuentra sqrt por defecto)
#include <klocale.h>







sociometricTest::sociometricTest()
{
this->newTest();
}


sociometricTest::~sociometricTest()
{
}


//  propiedades generales del test

// la ruta completa absoluta del path, terminada en /   
QString sociometricTest::getRutaFicheroTest()
{
return RutaFicheroTest;
};  


void sociometricTest::setRutaFicheroTest(QString value)
{
RutaFicheroTest=value;
};


// Numero de elecciones constanate 3 o 5 o 0   
int sociometricTest::getNumeroElecciones()
{
return numeroElecciones;
};  


void sociometricTest::setNumeroElecciones(int value)
{
numeroElecciones=value;
};

   
bool sociometricTest::getCriterioSociotelico()
{
return CriterioSociotelico;
};


void sociometricTest::setCriterioSociotelico(bool value)
{
CriterioSociotelico=value;
};


   
bool sociometricTest::getCriterioPsicotelico()
{
return CriterioPsicotelico;
};


void sociometricTest::setCriterioPsicotelico(bool value)
{
CriterioPsicotelico=value;
};


   
bool sociometricTest::getCriterioAutoridad()
{
return CriterioAutoridad;
};


void sociometricTest::setCriterioAutoridad(bool value)
{
CriterioAutoridad=value;
};



bool sociometricTest::getCriterioAfinidad()
{
return CriterioAfinidad;
};



void sociometricTest::setCriterioAfinidad(bool value)
{
CriterioAfinidad=value;
};


/*!
    \fn sociometricTest::setCriterioPropio(bool value)
 */
void sociometricTest::setCriterioPropio(bool value)
{
CriterioPropio=value;
}


/*!
    \fn sociometricTest::getCriterioPropio()
 */
bool sociometricTest::getCriterioPropio()
{
return CriterioPropio;
}



// propiedades generales del grupo
QString sociometricTest::getNombreInstitucion()
{
return NombreInstitucion;
};


void sociometricTest::setNombreInstitucion(QString value)
{
NombreInstitucion=value;
};


QString sociometricTest::getNombreTutor()
{
return NombreTutor;
};


void sociometricTest::setNombreTutor(QString value)
{
NombreTutor=value;
};


QString sociometricTest::getDescripcionGrupo()
{
return DescripcionGrupo;
};


void sociometricTest::setDescripcionGrupo(QString value)
{
DescripcionGrupo=value;
};


QString sociometricTest::getIdentificativoGrupo()
{
return IdentificativoGrupo;
};


void sociometricTest::setIdentificativoGrupo(QString value)
{
IdentificativoGrupo=value;
};


int sociometricTest::getNumeroAlumnosGrupo()
{
return NumeroAlumnosGrupo;
};


void sociometricTest::setNumeroAlumnosGrupo(int value)
{
NumeroAlumnosGrupo=value;
};


   





   



// value es Hombre o Mujer
int sociometricTest::getEleccionesIntraGrupo (QString value) 
{
int c,p,n=0;
for (c=1;c<=NumeroAlumnosGrupo;c++)
   {
   for (p=1;p<=numeroElecciones;p++)
      if (SexoAlumno[c]==value and SexoAlumno[eleccion[c][p]]==value) n++;
   };
return n;
};





// value es Hombre o Mujer
int sociometricTest::getEleccionesExtraGrupo (QString value) 
{
if (value!="Hombre" and value!="Mujer")
qWarning("Error en sociometricTest::getEleccionesExtraGrupo()");

int n=0;
QString sc,sp;
for (int c=1;c<=NumeroAlumnosGrupo;c++)
   {
   for (int p=1;p<=numeroElecciones;p++)
      {
      if (SexoAlumno[c]==value and SexoAlumno[eleccion[c][p]]!=value) n++;
      }
   };
return n;
};





// value es Hombre o Mujer
int sociometricTest::getNumeroAlumnosSexo (QString value)
{
int n=0;
for (int c=1;c<=NumeroAlumnosGrupo;c++)
    if (SexoAlumno[c]==value) n++;       
return n;
};






// procedimientos que gestionan la la base de datos de alumnos
// value es el index (indice) del alumno. Ademas value2 es la cadena o entero a almacenar
QString sociometricTest::getNombreAlumno (int value)
{
return NombreAlumno[value];
}





//value1 es el indice del alumno y value2 es la cadena con el nombre
void sociometricTest::setNombreAlumno (int value1, QString value2)
{
NombreAlumno[value1]=value2;
}
 




//value1 es el indice del alumno y value2 es el entero con la edad
int sociometricTest::getEdadAlumno (int value)
{
return EdadAlumno[value];
}






void sociometricTest::setEdadAlumno (int value1, int value2)
{
EdadAlumno[value1]=value2;
}





QString sociometricTest::getSexoAlumno (int value)
{
return SexoAlumno[value];
}

//value1 es el indice del alumno y value2 es la cadena con el sexto
void sociometricTest::setSexoAlumno (int value1, QString value2)
{
SexoAlumno[value1]=value2;
}



QString sociometricTest::getIdentificativoAlumno (int value)
{
return IdentificativoAlumno[value];
}




//value1 es el indice del alumno y value2 es la cadena con el identificativo
void sociometricTest::setIdentificativoAlumno (int value1, QString value2)
{
IdentificativoAlumno[value1]=value2;
}

 
   
   
// funciones que gestionan las respuestas al cuestionario de los alumnos
// value1 es Index de AlumnoEnEvaluacion, value2 es Orden en seleccion, value3 es Index de Alumno seleccionado (clickado)

void sociometricTest::setEleccion (int value1, int value2, int value3)
{
eleccion[value1][value2]=value3;
}




int sociometricTest::getEleccion (int value1, int value2)
{
return eleccion[value1][value2];
}




void sociometricTest::setRechazo (int value1, int value2, int value3)
{
rechazo[value1][value2]=value3;
}




int sociometricTest::getRechazo (int value1, int value2)
{
return rechazo[value1][value2];
}



void sociometricTest::setPercepcionEleccion (int value1, int value2, int value3)
{
PercepcionEleccion[value1][value2]=value3;
}


int sociometricTest::getPercepcionEleccion (int value1, int value2)
{
return PercepcionEleccion[value1][value2];
}



void sociometricTest::setPercepcionRechazo (int value1, int value2, int value3)
{
PercepcionRechazo[value1][value2]=value3;
}




int sociometricTest::getPercepcionRechazo (int value1, int value2)
{
return PercepcionRechazo[value1][value2];
}







// funciones que gestionan los valores sociometricos  generales de los alumnos
// value es el index del alumno

// status de elecciones
int sociometricTest::getSp (int value)
{
int c1,c2;
Sp[value]=0; // lo ponemos a cero para no ir acumulando resultados
    for (c1=1;c1<=NumeroAlumnosGrupo;c1++)
    {
       for (c2=1;c2<=numeroElecciones;c2++)
       {
         //array[AlumnoEnEvaluacion,PosicionEleccion] = AlumnoSeleccionado
         if (eleccion[c1][c2]==value) Sp[value]++;
       };
    };
return Sp[value];
}




// status de elecciones valorizadas  
int sociometricTest::getSpv (int value)
{
int c1,c2;
Spv[value]=0; // lo ponemos a cero para no ir acumulando resultados
    for (c1=1;c1<=NumeroAlumnosGrupo;c1++)
    {
       for (c2=1;c2<=numeroElecciones;c2++)
       {
         if (eleccion[c1][c2]==value) Spv[value]=Spv[value]+(numeroElecciones-c2+1);
       };
    };
return Spv[value];
}



// status de rechazos
int sociometricTest::getSn (int value)
{
int c1,c2;
Sn[value]=0; // lo ponemos a cero para no ir acumulando resultados
   for (c1=1;c1<=NumeroAlumnosGrupo;c1++)
     {
       for (c2=1;c2<=numeroElecciones;c2++)
       {
         //array[AlumnoEnEvaluacion,PosicionEleccion] = AlumnoSeleccionado
         if (rechazo[c1][c2]==value) Sn[value]++;
       };
     };
return Sn[value];
}





// status de rechazos valorizados
int sociometricTest::getSnv (int value)
{
int c1,c2;
Snv[value]=0; // lo ponemos a cero para no ir acumulando resultados
     for (c1=1;c1<=NumeroAlumnosGrupo;c1++)
     {
       for (c2=1;c2<=numeroElecciones;c2++)
       {
         //array[AlumnoEnEvaluacion,PosicionEleccion] = AlumnoSeleccionado
         if (rechazo[c1][c2]==value) Snv[value]=Snv[value]+(numeroElecciones-c2+1);
       };
     };
return Snv[value];
}




//  expansividad positiva
// TODO en el caso de elecciones ilimitadas esto hay que cambiarlo
int sociometricTest::getEp (int value)
{
Ep[value]=numeroElecciones;
return Ep[value];
}





//  expansividad negativa
// TODO en el caso de elecciones ilimitadas esto hay que cambiarlo
int sociometricTest::getEn (int value)
{
En[value]=numeroElecciones;
return En[value];
}





// Elecciones reciprocas
// Elecciones reciprocas: la suma de las elecciones mutuas sin ponderar
// No se tiene en cuena si son fuertes o debiles las reciprocidades
int sociometricTest::getRp (int value)
{
int c1,c2,c3;
Rp[value]=0;
for (c1=1;c1<=NumeroAlumnosGrupo;c1++)
{
    // condicional para que no duplique los resultados, si el sujeto es el mismo, no hacer el bucle
    if (c1!=value) 
    {
        for (c2=1;c2<=numeroElecciones;c2++)
        {
            for (c3=1;c3<=numeroElecciones;c3++)
            {
                // el alumno c1 ha elegido al alumno Value en la posicion c2, y el alumno Value a elegido a c1 en la posicion c3
                if ((eleccion[c1][c2]==value) and (eleccion[value][c3]==c1)) Rp[value]++;
            };
        };
    };
};
return Rp[value];

}




// Elecciones reciprocas ponderadas
// Elecciones reciprocas: la suma de las elecciones mutuas ponderadas
// la ponderacion se realiza sumando las elecciones ponderadas asi: 5 punto para la primera eleccion, 4 para la segunda, ...
// 2 para la cuarta, 1 para la 5 y restantes.

int sociometricTest::getRpv (int value)
{
int c1,c2,c3;
Rpv[value]=0;

   for (c1=1;c1<=NumeroAlumnosGrupo;c1++)
   {
       // condicional para que no duplique los resultados, si el sujeto es el mismo, no hacer el bucle
       if (c1!=value)
       {
       for (c2=1;c2<=numeroElecciones;c2++)
       {
          for (c3=1;c3<=numeroElecciones;c3++)
          {
              // el alumno c1 ha elegido al alumno Value en la posicion c2, y el alumno Value a elegido a c1 en la posicion c3
              if ((eleccion[c1][c2]==value) and (eleccion[value][c3]==c1))
              {
              if (c2==1) Rpv[value]=Rpv[value]+5;
              if (c2==2) Rpv[value]=Rpv[value]+4;
              if (c2==3) Rpv[value]=Rpv[value]+3;
              if (c2==4) Rpv[value]=Rpv[value]+2;
              if (c2>=5) Rpv[value]=Rpv[value]+1;
              
              if (c3==1) Rpv[value]=Rpv[value]+5;
              if (c3==2) Rpv[value]=Rpv[value]+4;
              if (c3==3) Rpv[value]=Rpv[value]+3;
              if (c3==4) Rpv[value]=Rpv[value]+2;
              if (c3>=5) Rpv[value]=Rpv[value]+1;

              };
          };
       };
       };
   };
return Rpv[value];
}





// Rechazos reciprocos
int sociometricTest::getRn (int value)
{
int c1,c2,c3;
Rn[value]=0;
   for (c1=1;c1<=NumeroAlumnosGrupo;c1++)
   {
       // condicional para que no duplique los resultados, si el sujeto es el mismo, no hacer el bucle
       if (c1!=value)
       {
           for (c2=1;c2<=numeroElecciones;c2++)
           {
              for (c3=1;c3<=numeroElecciones;c3++)
              {
              // el alumno c1 ha elegido al alumno Value en la posicion c2, y el alumno Value a elegido a c1 en la posicion c3
              if ((rechazo[c1][c2]==value) and (rechazo[value][c3]==c1)) Rn[value]++;
              };
           };
       };
   };
return Rn[value];
}




// Rechazos reciprocos ponderados
int sociometricTest::getRnv (int value)
{
int c1,c2,c3;
Rnv[value]=0;

   for (c1=1;c1<=NumeroAlumnosGrupo;c1++)
   {
       // condicional para que no duplique los resultados, si el sujeto es el mismo, no hacer el bucle
       if (c1!=value)
       {
       for (c2=1;c2<=numeroElecciones;c2++)
       {
          for (c3=1;c3<=numeroElecciones;c3++)
          {
              // el alumno c1 ha elegido al alumno Value en la posicion c2, y el alumno Value a elegido a c1 en la posicion c3
              if ((rechazo[c1][c2]==value) and (rechazo[value][c3]==c1))
              {
              if (c2==1) Rnv[value]=Rnv[value]+5;
              if (c2==2) Rnv[value]=Rnv[value]+4;
              if (c2==3) Rnv[value]=Rnv[value]+3;
              if (c2==4) Rnv[value]=Rnv[value]+2;
              if (c2>=5) Rnv[value]=Rnv[value]+1;
              
              if (c3==1) Rnv[value]=Rnv[value]+5;
              if (c3==2) Rnv[value]=Rnv[value]+4;
              if (c3==3) Rnv[value]=Rnv[value]+3;
              if (c3==4) Rnv[value]=Rnv[value]+2;
              if (c3>=5) Rnv[value]=Rnv[value]+1;

              };
          };
       };
       };
   };
return Rnv[value];
}





// Oposicion de sentimiento
int sociometricTest::getOS (int value)
{
int c1,c2;

   OS[value]=0;
   for (c1=1;c1<=NumeroAlumnosGrupo;c1++)
   {
       for (c2=1;c2<=numeroElecciones;c2++)
       {
       // el alumno c1 ha elegido al alumno Value en la posicion c2
       if (eleccion[value][c2]==c1) 
          {
          // el alumno Value ha rechazado a c1 en la posicion 1
          if (rechazo[c1][1]==value) OS[value]++;
          if (rechazo[c1][2]==value) OS[value]++;
          if (rechazo[c1][3]==value) OS[value]++;
          if (rechazo[c1][4]==value) OS[value]++;
          if (rechazo[c1][5]==value) OS[value]++;
          };
       };
   };
return OS[value];
}







   
// funciones que gestionan los valores sociometricos  (percepciones) de los alumnos
// value es el index del alumno
// percepcion de elecciones
int sociometricTest::getPp (int value)
{
Pp[value]=numeroElecciones; // TODO si esta forzado un numero de percepcion de elecciones
return Pp[value];
}


// percepcion acertada de elecciones
int sociometricTest::getPAp (int value)
{
int c1,c2;

   PAp[value]=0;
   for (c1=1;c1<=NumeroAlumnosGrupo;c1++)
   {
       for (c2=1;c2<=numeroElecciones;c2++)
       {
       // el alumno Value se percibe elegido por el alumno c1 en la posicion c2
       if (PercepcionEleccion[value][c2]==c1)
          {
            if (numeroElecciones>=3)
            {
                // el alumno c1 ha elegido a Value en la posicion 1
                if (eleccion[c1][1]==value) PAp[value]++;
                if (eleccion[c1][2]==value) PAp[value]++;
                if (eleccion[c1][3]==value) PAp[value]++;
            };
            if (numeroElecciones==5)
            {
                if (eleccion[c1][4]==value) PAp[value]++;
                if (eleccion[c1][5]==value) PAp[value]++;
            };
          };
       };
   };
return PAp[value];
}




// percepcion de rechazo
int sociometricTest::getPn (int value)
{
Pn[value]=numeroElecciones; // si esta forzado a un numero de percepcion de rechazos
return Pn[value];
 
}





// percepcion acertada de rechazo
int sociometricTest::getPAn (int value)
{
int c1,c2;
   PAn[value]=0;
   for (c1=1;c1<=NumeroAlumnosGrupo;c1++)
   {
       for (c2=1;c2<=numeroElecciones;c2++)
       {
       // el alumno Value se percibe rechazado por el alumno c1 en la posicion c2
       if (PercepcionRechazo[value][c2]==c1)
          {
          if (numeroElecciones>=3)
          {
          // el alumno c1 ha rechazado a Value en la posicion 1
          if (rechazo[c1][1]==value) PAn[value]++;
          if (rechazo[c1][2]==value) PAn[value]++;
          if (rechazo[c1][3]==value) PAn[value]++;
          };
          if (numeroElecciones==5)
            {
            if (rechazo[c1][4]==value) PAn[value]++;
            if (rechazo[c1][5]==value) PAn[value]++;
            };
          };
       };
   };
return PAn[value];
}





// Impresion de elecciones
int sociometricTest::getIp (int value)
{
int c1,c2;
   Ip[value]=0;
   for (c1=1;c1<=NumeroAlumnosGrupo;c1++)
   {
       for (c2=1;c2<=numeroElecciones;c2++)
       {
       // el alumno c1 se percibe elegido por el alumno Value en la posicion c2
       if (PercepcionEleccion[c1][c2]==value) Ip[value]++;
       };
   };
return Ip[value];
}





// Impresion de rechazos
int sociometricTest::getIn (int value)
{
int c1,c2;
In[value]=0;
   for (c1=1;c1<=NumeroAlumnosGrupo;c1++)
   {
       for (c2=1;c2<=numeroElecciones;c2++)
       {
       // el alumno c1 se percibe rechazado por el alumno Value en la posicion c2
       if (getPercepcionRechazo(c1,c2)==value) In[value]++;
       };
   };
return In[value];
}





// Falsa percepcion
int sociometricTest::getFP (int value)
{
int c1,c2;
bool flag1, flag2;

   FP[value]=0;
   for (c1=1;c1<=NumeroAlumnosGrupo;c1++)
   {
       flag1=FALSE;
       flag2=FALSE;
       for (c2=1;c2<=numeroElecciones;c2++)
       {
       
       // el alumno Value se percibe como elegido por el alumno c1 en la posicion c2
       if (getPercepcionEleccion(value,c2)==c1)
          {
          // el alumno c1 ha rechazado a Value en la posicion 1,2,3,4,5, o bien, c1 no ha tenido en cuenta a Value
          if (getRechazo(c1,1)==value) FP[value]++;flag1=TRUE;
          if (getRechazo(c1,2)==value) FP[value]++;flag1=TRUE;
          if (getRechazo(c1,3)==value) FP[value]++;flag1=TRUE;
          if (getRechazo(c1,4)==value) FP[value]++;flag1=TRUE;
          if (getRechazo(c1,5)==value) FP[value]++;flag1=TRUE;
          };
          
       // el alumno Value se percibe como rechazado por el alumno c1 en la posicion c2
       if (getPercepcionRechazo(value,c2)==c1)
          {
          // el alumno c1 ha elegido a Value en la posicion 1
          if (getEleccion(c1,1)==value) FP[value]++;flag2=TRUE;
          if (getEleccion(c1,2)==value) FP[value]++;flag2=TRUE;
          if (getEleccion(c1,3)==value) FP[value]++;flag2=TRUE;
          if (getEleccion(c1,4)==value) FP[value]++;flag2=TRUE;
          if (getEleccion(c1,5)==value) FP[value]++;flag2=TRUE;
          };
       };
       // estos flags nos indican si el alumno Value no ha sido tenido en cuenta por otro c1, pero Value a percibido eleccion o rechazo
       if (flag1==FALSE) FP[value]++;
       if (flag2==FALSE) FP[value]++;
   };
return FP[value];
}






//funcion de calculo de la distancia socometrica entre value1 y value2
int sociometricTest::getDistSociometrica(int value1, int value2)
{
int c,distSociometric;
  
distSociometric=0;
for (c=1;c<=numeroElecciones;c++)
{
if (getEleccion(value1,c)==value2) distSociometric++;
if (getEleccion(value2,c)==value1) distSociometric++;
if (getRechazo(value1,c)==value2) distSociometric--;
if (getRechazo(value2,c)==value1) distSociometric--;
if (getPercepcionEleccion(value1,c)==value2) distSociometric++;
if (getPercepcionEleccion(value2,c)==value1) distSociometric++;
if (getPercepcionRechazo(value1,c)==value2) distSociometric--;
if (getPercepcionRechazo(value2,c)==value1) distSociometric--;
};
return distSociometric;
}









// procedimiento para calcular los parametros estadisticos de la muestra: p, q, med, desv, asim
// entrada: value que es una cadena con el nombre del valor sociometrico sobre el que se calculan los stadisticos
void sociometricTest::ParametrosEstadisticos (QString value)
{
double d;// media de las elecciones que un individuo puede hacer
double SS;// sumatorio de un valores sociometricos para todos los alumnos del grupo
int c;


// caso de numeroElecciones constante (3 o 5)
if (numeroElecciones!=0)
Param_P=(double)numeroElecciones/(NumeroAlumnosGrupo-1);




// caso de numeroElecciones ilimitado
// TODO este caso de ilimitadas elecciones esta por implementar en un futuro
if (numeroElecciones==-1) 
{
	SS=0; // inicializamos la variable

	if (value=="Sp") 
	{
	
	for (c=1;c<=NumeroAlumnosGrupo;c++) SS=SS+getSp(c);
	d=SS/NumeroAlumnosGrupo;
	};
	
	if (value=="Spv")
	{
	
	for (c=1;c<=NumeroAlumnosGrupo;c++) SS=SS+getSpv(c);
	d=SS/NumeroAlumnosGrupo;
	};
	
	if (value=="Sn")
	{
	
	for (c=1;c<=NumeroAlumnosGrupo;c++) SS=SS+getSn(c);
	d=SS/NumeroAlumnosGrupo;
	};
	
	if (value=="Snv")
	{
	
	for (c=1;c<=NumeroAlumnosGrupo;c++) SS=SS+getSnv(c);
	d=SS/NumeroAlumnosGrupo;
	};
	
	if (value=="Ep")
	{
	for (c=1;c<=NumeroAlumnosGrupo;c++) SS=SS+getEp(c);
	d=SS/NumeroAlumnosGrupo;
	};
	
	if (value=="En")
	{
	for (c=1;c<=NumeroAlumnosGrupo;c++) SS=SS+getEn(c);
	d=SS/NumeroAlumnosGrupo;
	};
	
	if (value=="Rp")
	{
	for (c=1;c<=NumeroAlumnosGrupo;c++) SS=SS+getRp(c);
	d=SS/NumeroAlumnosGrupo;
	};
	
	if (value=="Rpv")
	{
	for (c=1;c<=NumeroAlumnosGrupo;c++) SS=SS+getRpv(c);
	d=SS/NumeroAlumnosGrupo;
	};
	
	if (value=="Rn")
	{
	for (c=1;c<=NumeroAlumnosGrupo;c++) SS=SS+getRn(c);
	d=SS/NumeroAlumnosGrupo;
	};
	
	if (value=="Rnv")
	{
	for (c=1;c<=NumeroAlumnosGrupo;c++) SS=SS+getRnv(c);
	d=SS/NumeroAlumnosGrupo;
	};
	
	if (value=="OS")
	{
	for (c=1;c<=NumeroAlumnosGrupo;c++) SS=SS+getOS(c);
	d=SS/NumeroAlumnosGrupo;
	};
	
	
	if (value=="Pp")
	{
	for (c=1;c<=NumeroAlumnosGrupo;c++) SS=SS+getPp(c);
	d=SS/NumeroAlumnosGrupo;
	};
	
	if (value=="Pn")
	{
	for (c=1;c<=NumeroAlumnosGrupo;c++) SS=SS+getPn(c);
	d=SS/NumeroAlumnosGrupo;
	};
	
	if (value=="PAp")
	{
	for (c=1;c<=NumeroAlumnosGrupo;c++) SS=SS+getPAp(c);
	d=SS/NumeroAlumnosGrupo;
	};
	
	if (value=="PAn")
	{
	for (c=1;c<=NumeroAlumnosGrupo;c++) SS=SS+getPAn(c);
	d=SS/NumeroAlumnosGrupo;
	};
	
	if (value=="Ip")
	{
	for (c=1;c<=NumeroAlumnosGrupo;c++) SS=SS+getIp(c);
	d=SS/NumeroAlumnosGrupo;
	};
	
	if (value=="In")
	{
	for (c=1;c<=NumeroAlumnosGrupo;c++) SS=SS+getIn(c);
	d=SS/NumeroAlumnosGrupo;
	};
	
	if (value=="FP")
	{
	for (c=1;c<=NumeroAlumnosGrupo;c++) SS=SS+getFP(c);
	d=SS/NumeroAlumnosGrupo;
	};
	
	
	Param_P=d/(NumeroAlumnosGrupo);
	
}


Param_Q=1-Param_P;
Param_Med=Param_P*(NumeroAlumnosGrupo-1);
Param_Desv=sqrt((NumeroAlumnosGrupo-1)*Param_P*Param_Q);
Param_Asim=(Param_Q-Param_P)/Param_Desv;



}

// parametros estadisticos de la muestra
double sociometricTest::getParam_P (QString value)
{
ParametrosEstadisticos (value);
return Param_P;
}


double sociometricTest::getParam_Q (QString value)
{
ParametrosEstadisticos (value);
return Param_Q;
}


double sociometricTest::getParam_Med (QString value)
{
ParametrosEstadisticos (value);
return Param_Med;
}


double sociometricTest::getParam_Desv (QString value)
{
ParametrosEstadisticos (value);
return Param_Desv;
}


double sociometricTest::getParam_Asim (QString value)
{
ParametrosEstadisticos (value);
return Param_Asim;
}


   
   
   
   



// funciones para el calculo de significacion
// funcion que calcula el limite superior del estadistico t
// bajo la teoria de <<probabilidad teorica del azar>>
double sociometricTest::getLimSup(QString value)
{
double t = 0.00;


// FIX ME: atencion: se utiliza siempre el mismo estadistico de contraste
// X=M+t*d aun cuando no es valido para todos los valores. Esto solo es aplicable
// a Sp, Sn, Ep, En, Pp, Pn, Ip, In


// en vez de hacer el calculo con la distribucion t, hago una aproximacion
// mas que suficiente, como si fuera una tabla, conociendo el grado de
// oblicuidad derecha o positiva, para un margen de error del 0.05
double asimetria=getParam_Asim(value);

if ((asimetria>=0.00) and (asimetria<0.05)) t= 1.64;
if ((asimetria>=0.05) and (asimetria<0.15)) t= 1.67;
if ((asimetria>=0.15) and (asimetria<0.25)) t= 1.70;
if ((asimetria>=0.25) and (asimetria<0.35)) t= 1.73;
if ((asimetria>=0.35) and (asimetria<0.45)) t= 1.75;
if ((asimetria>=0.45) and (asimetria<0.55)) t= 1.77;
if ((asimetria>=0.55) and (asimetria<0.65)) t= 1.80;
if ((asimetria>=0.65) and (asimetria<0.75)) t= 1.82;
if ((asimetria>=0.75) and (asimetria<0.85)) t= 1.84;
if ((asimetria>=0.85) and (asimetria<0.95)) t= 1.86;
if ((asimetria>=0.95) and (asimetria<1.05)) t= 1.88;
if (asimetria>=1.05) t= 1.89;

return getParam_Med(value)+(t*getParam_Desv(value));
}















// funcion que calcula el limite inferior del estadistico t
// bajo la teoria de <<probabilidad teorica del azar>>
double sociometricTest::getLimInf(QString value)
{
double t;


// FIX ME: atencion: se utiliza siempre el mismo estadistico de contraste
// X=M+t*d aun cuando no es valido para todos los valores. Esto solo es aplicable
// a Sp, Sn, Ep, En, Pp, Pn, Ip, In


// en vez de hacer el calculo con la distribucion t, hago una aproximacion
// mas que suficiente, como si fuera una tabla, conociendo el grado de
// oblicuidad derecha o positiva, para un margen de error del 0.05
double asimetria=getParam_Asim(value);

if ((asimetria>=0.00) and (asimetria<0.05)) t= -1.64;
if ((asimetria>=0.05) and (asimetria<0.15)) t= -1.62;
if ((asimetria>=0.15) and (asimetria<0.25)) t= -1.59;
if ((asimetria>=0.25) and (asimetria<0.35)) t= -1.56;
if ((asimetria>=0.35) and (asimetria<0.45)) t= -1.52;
if ((asimetria>=0.45) and (asimetria<0.55)) t= -1.49;
if ((asimetria>=0.55) and (asimetria<0.65)) t= -1.46;
if ((asimetria>=0.65) and (asimetria<0.75)) t= -1.42;
if ((asimetria>=0.75) and (asimetria<0.85)) t= -1.39;
if ((asimetria>=0.85) and (asimetria<0.95)) t= -1.35;
if ((asimetria>=0.95) and (asimetria<1.05)) t= -1.32;
if (asimetria>=1.05) t= -1.28;

return getParam_Med(value)+(t*getParam_Desv(value));
}








// indices sociometricos individulaes

// indice de popularidad
double sociometricTest::getPop (int value)
{
if (NumeroAlumnosGrupo-1==0)
{
Pop[value]= 99.999;
return Pop[value];
}

Pop[value]=(double)getSp(value)/(double)(NumeroAlumnosGrupo-1);
return Pop[value];

}


// indice de antipatia
double sociometricTest::getAnt (int value)
{
if (NumeroAlumnosGrupo-1==0) Ant[value]=99.999;
else 
Ant[value]=(double)getSn(value)/(double)(NumeroAlumnosGrupo-1);

return Ant[value];
}


// indice de expansion positiva
double sociometricTest::getExpp (int value)
{
if (NumeroAlumnosGrupo-1==0) Expp[value]=99.999;
else 
Expp[value]=(double)getEp(value)/(double)(NumeroAlumnosGrupo-1);

return Expp[value];
}


// indice de expansion negativa
double sociometricTest::getExpn (int value)
{
if (NumeroAlumnosGrupo-1==0) Expn[value]=99.999;
else 
Expn[value]=(double)getEn(value)/(double)(NumeroAlumnosGrupo-1);

return Expn[value];
}


// indice de conexion afectiva
double sociometricTest::getCA (int value)
{
if (getSp(value)==0) CA[value]=99.999;
else CA[value]=(double)getRp(value)/(double)getSp(value);

return CA[value];
}


// indice de atencion perceptiva
double sociometricTest::getAP (int value)
{
if (getSp(value)+getSn(value)==0) AP[value]=99.999;
else AP[value]=(double)(getPAp(value)+getPAn(value))/(double)(getSp(value)+getSn(value));

return AP[value];
}


// indice de realismo perceptivo
double sociometricTest::getRPER (int value)
{
if (getPp(value)+getPn(value)==0) RPER[value]=99.999;
else RPER[value]=(double)(getPAp(value)+getPAn(value))/(double)(getPp(value)+getPn(value));

return RPER[value];
}


// status sociometrico
double sociometricTest::getSS (int value)
{
if (NumeroAlumnosGrupo-1==0)
    {
    SS[value]= 99.999;
    }
else 
    {
    // la conversion a double es necesario para que no de 0
    SS[value]=(double)((getSp(value)+getPp(value))-(getSn(value)+getPn(value)))/(double)(NumeroAlumnosGrupo-1);
    }
return SS[value];
}



   
   
// indice sociometricos globales
// indice de asociacion
double sociometricTest::getGIA()
{
int c;
double SS=0;
double result;

if (numeroElecciones==0 or NumeroAlumnosGrupo-1==0 or NumeroAlumnosGrupo==0)
return 99.999;



   //TODO
   if (numeroElecciones==-1)
       {
       for (c=1;c<=NumeroAlumnosGrupo;c++) 
       SS=SS+getRp(c);
       result= SS/(double)(NumeroAlumnosGrupo*(NumeroAlumnosGrupo-1));
       };
   
   if (numeroElecciones>0)
       {
       for (c=1;c<=NumeroAlumnosGrupo;c++) 
       SS=SS+getRp(c);
       result= SS/(double)(numeroElecciones*NumeroAlumnosGrupo);
       };
return result;
}


// indice de disociacion
double sociometricTest::getGID()
{
int c;
double SS=0;
double result;

if (numeroElecciones==0 or NumeroAlumnosGrupo-1==0 or NumeroAlumnosGrupo==0)
return 99.999;


   if (numeroElecciones==-1)
       {
       for (c=1;c<=NumeroAlumnosGrupo;c++) SS=SS+getRn(c);
       result=SS/(double)(NumeroAlumnosGrupo*(NumeroAlumnosGrupo-1));
       };
   if (numeroElecciones>0) 
       {
       for (c=1;c<=NumeroAlumnosGrupo;c++) SS=SS+getRn(c);
       result=SS/(double)(numeroElecciones*NumeroAlumnosGrupo);
       };
return result;
}


// indice de coherencia
double sociometricTest::getGIC()
{
int c;
double SS1,SS2;
SS1=0;
SS2=0;
   
   for (c=1;c<=NumeroAlumnosGrupo;c++) SS1=SS1+getRp(c);
   for (c=1;c<=NumeroAlumnosGrupo;c++) SS2=SS2+getSp(c);
   if (SS2==0) return 99.999;
   else return SS1/SS2;
}


// indice de intensidad social
double sociometricTest::getGIS()
{
int c;
double SS1,SS2;
SS1=0;
SS2=0;
   for (c=1;c<=NumeroAlumnosGrupo;c++) SS1=SS1+getSp(c);
   for (c=1;c<=NumeroAlumnosGrupo;c++) SS2=SS2+getSn(c);
   return (SS1+SS2)/(double)(NumeroAlumnosGrupo-1);
}


// indice de preferencias del subgrupo (value: Hombre o Mujer)
double sociometricTest::getGPS(QString value)
{

if (getEleccionesExtraGrupo(value)*(getNumeroAlumnosSexo(value)-1)==0) 
    return 99.999;
    
 
    
   
else 
    return (double)(getEleccionesIntraGrupo(value)*(NumeroAlumnosGrupo-getNumeroAlumnosSexo(value)))/(double)(getEleccionesExtraGrupo(value)*(getNumeroAlumnosSexo(value)-1));



}


// indice de union del subgrupo (value: Hombre o Mujer)
double sociometricTest::getGUS(QString value)
{
//TODO
return 0.000;
}







   // propiedades con las tareas pendientes y terminadas
bool sociometricTest::getTarea1()
{
return tarea1;
};


void sociometricTest::setTarea1(bool value)
{
tarea1=value;
};


bool sociometricTest::getTarea2()
{
return tarea2;
};


void sociometricTest::setTarea2(bool value)
{
tarea2=value;
};


bool sociometricTest::getTarea3()
{
return tarea3;
};


void sociometricTest::setTarea3(bool value)
{
tarea3=value;
};


bool sociometricTest::getTarea4()
{
return tarea4;
};


void sociometricTest::setTarea4(bool value)
{
tarea4=value;
};


/*!
    \fn sociometricTest::setTarea5(bool value)
 */
void sociometricTest::setTarea(QString typeSociogram, bool value)
{
/*
typeSociogram puede valer:
strongElection
weakElection
strongRejection
weakRejection
reciprocalElection
reciprocalRejection
reciprocalElectionAndRejection
*/

 
   if (typeSociogram=="strongElection") strongElectionSociogram = value;
   if (typeSociogram=="weakElection") weakElectionSociogram = value;
   if (typeSociogram=="strongRejection") strongRejectionSociogram = value;
   if (typeSociogram=="weakRejection") weakRejectionSociogram = value; 
   if (typeSociogram=="reciprocalElection") reciprocalElectionSociogram = value;
   if (typeSociogram=="reciprocalRejection") reciprocalRejectionSociogram = value;
   if (typeSociogram=="reciprocalElectionAndRejection") reciprocalElectionAndRejectionSociogram = value;

}




bool sociometricTest::getTarea(QString typeSociogram)
{
/*
typeSociogram puede valer:
strongElection
weakElection
strongRejection
weakRejection
reciprocalElection
reciprocalRejection
reciprocalElectionAndRejection
*/

 
   if (typeSociogram=="strongElection") return strongElectionSociogram;
   else if (typeSociogram=="weakElection") return weakElectionSociogram;
   else if (typeSociogram=="strongRejection") return strongRejectionSociogram;
   else if (typeSociogram=="weakRejection") return weakRejectionSociogram; 
   else if (typeSociogram=="reciprocalElection") return reciprocalElectionSociogram;
   else if (typeSociogram=="reciprocalRejection") return reciprocalRejectionSociogram;
   else if (typeSociogram=="reciprocalElectionAndRejection") return reciprocalElectionAndRejectionSociogram;
   else return FALSE; // ESTA LTIMA SALIDA NO TIENE SENTIDO

}


















// procedimientos para grabar los datos de cada tarea en el fichero ini
void sociometricTest::GrabaDatosGeneralesTest (QString filename = "~/SociometricTest.smt") 
{

Config ConfigFile(filename);
ConfigFile.setGroup("PropiedadesGeneralesTest");
//ConfigFile.writeEntry("NombreFicheroTest", getNombreFicheroTest() );
//ConfigFile.writeEntry( "RutaFicheroTest", getRutaFicheroTest() );
ConfigFile.writeEntry( "CriterioPsicotelico", getCriterioPsicotelico () );
ConfigFile.writeEntry( "CriterioSociotelico", getCriterioSociotelico () );
ConfigFile.writeEntry( "CriterioAutoridad", getCriterioAutoridad () );
ConfigFile.writeEntry( "CriterioAfinidad", getCriterioAfinidad () );
ConfigFile.writeEntry( "NumeroElecciones",getNumeroElecciones()); 
ConfigFile.setGroup("TareasRealizadas");
ConfigFile.writeEntry( "Tarea1", getTarea1() );
ConfigFile.write();


}


void sociometricTest::GrabaDatosGeneralesGrupo (QString filename = "~/SociometricTest.smt") 
{
Config ConfigFile(filename);
ConfigFile.setGroup("PropiedadesGeneralesGrupo");
ConfigFile.writeEntry( "NombreInstitucion", getNombreInstitucion() );
ConfigFile.writeEntry( "NombreTutor", getNombreTutor() );
ConfigFile.writeEntry( "DescripcionGrupo", getDescripcionGrupo() );
ConfigFile.writeEntry( "IdentificativoGrupo", getIdentificativoGrupo() );
ConfigFile.writeEntry( "NumeroAlumnosGrupo", getNumeroAlumnosGrupo() );
ConfigFile.setGroup("TareasRealizadas");
ConfigFile.writeEntry( "Tarea2", getTarea2() );
ConfigFile.write();
}


void sociometricTest::GrabaBaseDatosAlumnos (QString filename = "~/SociometricTest.smt")
{
Config ConfigFile(filename);
QString sn;
for (int n=1;n<=getNumeroAlumnosGrupo();n++)
{
    sn = sn.setNum(n);
    ConfigFile.setGroup(sn);
    ConfigFile.writeEntry( "NombreAlumno", getNombreAlumno(n) );
    ConfigFile.writeEntry( "EdadAlumno", getEdadAlumno(n) );
    ConfigFile.writeEntry( "SexoAlumno", getSexoAlumno(n) );
    ConfigFile.writeEntry( "IdentificativoAlumno", getIdentificativoAlumno(n) );
}
ConfigFile.setGroup("TareasRealizadas");
ConfigFile.writeEntry( "Tarea3", getTarea3() );
ConfigFile.write();
}






// graba solo una respuesta, la del alumno value
// no se graba tarea4 como terminada
bool sociometricTest::GrabaRespuestas (int value, QString filename = "~/SociometricTest.smt") 
{
Config ConfigFile(filename);
QString sn=QString::null;
ConfigFile.setGroup(sn.setNum(value));
ConfigFile.writeEntry( "EsEvaluado", getEsEvaluado(value) );

// se graban la edad y sexo por si no se introdujeron en 
// la tabla de alumnos, pero si los ha metido el propio alumno al realizar
// el cuestionario

ConfigFile.writeEntry( "EdadAlumno",getEdadAlumno(value) );
ConfigFile.writeEntry( "SexoAlumno",getSexoAlumno(value) );

QString sc;
for (int c=1;c<=numeroElecciones;c++)
{
    sc=QString::null;
    sc = sc.setNum(c);
    ConfigFile.writeEntry("Eleccion_" + sc, eleccion[value][c]);
    ConfigFile.writeEntry("Rechazo_" + sc, rechazo[value][c]);
    ConfigFile.writeEntry("PercepcionEleccion_" + sc, PercepcionEleccion[value][c]);
    ConfigFile.writeEntry("PercepcionRechazo_" + sc, PercepcionRechazo[value][c]);
};
ConfigFile.write();
return TRUE;
}




// procedimientos para cargar del disco los datos desde el fichero ini
bool sociometricTest::CargaDatosGeneralesTest (QString filename) 
{
Config ConfigFile(filename);
ConfigFile.setGroup("PropiedadesGeneralesTest");
//setNombreFicheroTest(ConfigFile.readEntry("NombreFicheroTest"));
//setRutaFicheroTest(ConfigFile.readEntry("RutaFicheroTest"));
setCriterioPsicotelico(ConfigFile.readBoolEntry("CriterioPsicotelico"));
setCriterioSociotelico(ConfigFile.readBoolEntry("CriterioSociotelico"));
setCriterioAutoridad(ConfigFile.readBoolEntry("CriterioAutoridad"));
//setCriterioAfinidad(ConfigFile.readBoolEntry("CriterioAfinidad"));
setNumeroElecciones(ConfigFile.readNumEntry("NumeroElecciones",-1)); 
ConfigFile.setGroup("TareasRealizadas");
setTarea1(ConfigFile.readBoolEntry( "Tarea1"));
return TRUE;
}


bool sociometricTest::CargaDatosGeneralesGrupo (QString filename) 
{
Config ConfigFile(filename);
ConfigFile.setGroup("PropiedadesGeneralesGrupo");
setNombreInstitucion(ConfigFile.readEntry("NombreInstitucion"));
setNombreTutor(ConfigFile.readEntry("NombreTutor"));
setDescripcionGrupo(ConfigFile.readEntry("DescripcionGrupo"));
setIdentificativoGrupo(ConfigFile.readEntry("IdentificativoGrupo"));
setNumeroAlumnosGrupo(ConfigFile.readNumEntry("NumeroAlumnosGrupo",-1));
ConfigFile.setGroup("TareasRealizadas");
setTarea2(ConfigFile.readBoolEntry("Tarea2"));
return TRUE;
}


bool sociometricTest::CargaBaseDatosAlumnos (QString filename) 
{

Config ConfigFile(filename);
QString sn;
for (int n=1;n<=getNumeroAlumnosGrupo();n++)
{
    sn = sn.setNum(n);
    ConfigFile.setGroup(sn);
    setNombreAlumno(n,ConfigFile.readEntry("NombreAlumno"));
    setEdadAlumno(n,ConfigFile.readNumEntry("EdadAlumno",-1));
    setSexoAlumno(n,ConfigFile.readEntry("SexoAlumno"));
    setIdentificativoAlumno(n,ConfigFile.readEntry("IdentificativoAlumno"));
}
ConfigFile.setGroup("TareasRealizadas");
setTarea3(ConfigFile.readBoolEntry("Tarea3"));
return TRUE;
}


bool sociometricTest::CargaRespuestas (QString filename) 
{
QString sn,sc;
Config ConfigFile(filename);
for (int n=1;n<=getNumeroAlumnosGrupo();n++)
{
    sn = sn.setNum(n);
    for (int c=1;c<=getNumeroElecciones();c++)
    {
        sc = sc.setNum(c);
        ConfigFile.setGroup(sn);
        setEsEvaluado(n,ConfigFile.readBoolEntry("EsEvaluado"));
    
        // array[AlumnoEnEvaluacion,PosicionEleccion] = AlumnoSeleccionado
        setEleccion(n,c,ConfigFile.readNumEntry("Eleccion_"+sc,-1));
        setRechazo(n,c,ConfigFile.readNumEntry("Rechazo_"+sc,-1));
        setPercepcionEleccion(n,c,ConfigFile.readNumEntry("PercepcionEleccion_"+sc,-1));
        setPercepcionRechazo(n,c,ConfigFile.readNumEntry("PercepcionRechazo_"+sc,-1));
    }
}
ConfigFile.setGroup("TareasRealizadas");
setTarea4(ConfigFile.readBoolEntry("Tarea4"));
return TRUE;
}


   
// procedimiento para saber si un alumno ha realizado el cuestionario
bool sociometricTest::getEsEvaluado(int idStudent) 
{
return EsEvaluado[idStudent];
}

// procedimiento para saber si un alumno ha realizado el cuestionario
void sociometricTest::setEsEvaluado(int idStudent, bool value) 
{
EsEvaluado[idStudent]=value;
}

   


// guarda el alumno que se muestra en el sociograma individual
void sociometricTest::setStudentShow(int idStudent)
{
studentShow=idStudent;
}


// muestra el numero del alumno que se muestra en el sociograma individual
int sociometricTest::getStudentShow()
{
return studentShow;
}



// guarda el tipo de sociograma que se muestra en el sociograma de grupo
void sociometricTest::setSociogramShow(QString typeSociogram)
{
sociogramShow=typeSociogram;
}


// muestra el numero del alumno que se muestra en el sociograma individual
QString sociometricTest::getSociogramShow()
{
return sociogramShow;
}




/*!
    \fn sociometricTest::getSociometricValue(QString sValue, int idStudent)
 */
double sociometricTest::getSociometricValue(QString sValue, int idStudent)
{
    if (sValue=="Sp") return getSp(idStudent);
    else if (sValue=="Sn") return getSn(idStudent);
    else if (sValue=="Ep") return getEp(idStudent);
    else if (sValue=="Ep") return getEn(idStudent);
    else if (sValue=="Ip") return getIp(idStudent);
    else if (sValue=="Ip") return getIn(idStudent);
    else if (sValue=="Pp") return getPp(idStudent);
    else if (sValue=="Pn") return getPn(idStudent);
    else return 0; // este ltimo valor de retorno no tiene sentido 
}





/*!
    Salida:
    <0 relacion debil
    =0 No hay relacion
    >0 relacion fuerte
 */
int sociometricTest::isReciprocalElection(int n, int m)
{
  for (int em=1;em<=numeroElecciones;em++)
  {
     for (int en=1;en<=numeroElecciones;en++)
     {
        if (eleccion[m][em]==n and eleccion[n][en]==m)
        {
        if (em<=2 and en<=2) return +1;
        else return -1;
        } 
     }
  } 
return 0;
}


/*!
    Salida:
    <0 relacion debil
    =0 No hay relacion
    >0 relacion fuerte
 */
 int sociometricTest::isReciprocalRejection(int m, int n)
{
  for (int em=1;em<=numeroElecciones;em++)
  {
     for (int en=1;en<=numeroElecciones;en++)
     {
        if (rechazo[m][em]==n and rechazo[n][en]==m)
        {
        if (em<=2 and en<=2) return +1;
        else return -1;
        } 
     }
  } 
return 0;
}




/*!
    Salida:
    <0 relacion debil
    =0 No hay relacion
    >0 relacion fuerte
 */
int sociometricTest::isElection(int m, int n)
{
     for (int e=1;e<=numeroElecciones;e++)
     {
        if (eleccion[m][e]==n)
            {
                if (e<=2) return +1;
                else return -1;
            } 
     }
return 0;
}


/*!
    Salida:
    <0 relacion debil
    =0 No hay relacion
    >0 relacion fuerte
 */
int sociometricTest::isRejection(int m, int n)
{
     for (int e=1;e<=numeroElecciones;e++)
     {
        if (rechazo[m][e]==n)
            {
                if (e<=2) return +1;
                else return -1;
            } 
     }
return 0;
}













/*!
    Salva la posicion x,y de un tipo de test sociometrico de grupo
 */
void sociometricTest::savePosition(QString typeSociogram, QString filename)
{

Config ConfigFile(filename);
QString sn;
for (int n=1;n<=getNumeroAlumnosGrupo();n++)
{
    sn = sn.setNum(n);
    ConfigFile.setGroup(sn);
    ConfigFile.writeEntry( typeSociogram+"_Cx", getCx(n,typeSociogram) );
    ConfigFile.writeEntry( typeSociogram+"_Cy", getCy(n,typeSociogram) );
}
ConfigFile.setGroup("TareasRealizadas");
ConfigFile.writeEntry( typeSociogram, getTarea(typeSociogram) );
ConfigFile.write();


}


/*!
    \fn sociometricTest::getCx(QString typeSociogram)
 */
int sociometricTest::getCx(int idStudent, QString typeSociogram)
{
/*
typeSociogram puede valer:
strongElection
weakElection
strongRejection
weakRejection
reciprocalElection
reciprocalRejection
reciprocalElectionAndRejection
*/
if (typeSociogram=="reciprocalElectionAndRejection")
    return reciprocalElectionAndRejection_Cx[idStudent];
if (typeSociogram=="reciprocalElection")
    return reciprocalElection_Cx[idStudent];
if (typeSociogram=="reciprocalRejection")
    return reciprocalRejection_Cx[idStudent];
if (typeSociogram=="strongRejection")
    return strongRejection_Cx[idStudent];
if (typeSociogram=="strongElection")
    return strongElection_Cx[idStudent];
if (typeSociogram=="weakRejection")
    return weakRejection_Cx[idStudent];
if (typeSociogram=="weakElection")
    return weakElection_Cx[idStudent];

return 0;
}


/*!
    \fn sociometricTest::getCy(QString typeSociogram)
 */
int sociometricTest::getCy(int idStudent, QString typeSociogram)
{
/*
typeSociogram puede valer:
strongElection
weakElection
strongRejection
weakRejection
reciprocalElection
reciprocalRejection
reciprocalElectionAndRejection
*/
if (typeSociogram=="reciprocalElectionAndRejection")
    return reciprocalElectionAndRejection_Cy[idStudent];
if (typeSociogram=="reciprocalElection")
    return reciprocalElection_Cy[idStudent];
if (typeSociogram=="reciprocalRejection")
    return reciprocalRejection_Cy[idStudent];
if (typeSociogram=="strongRejection")
    return strongRejection_Cy[idStudent];
if (typeSociogram=="strongElection")
    return strongElection_Cy[idStudent];
if (typeSociogram=="weakRejection")
    return weakRejection_Cy[idStudent];
if (typeSociogram=="weakElection")
    return weakElection_Cy[idStudent];
    
return 0;
}





void sociometricTest::setCx(int idStudent, QString typeSociogram, int x)
{
/*
typeSociogram puede valer:
strongElection
weakElection
strongRejection
weakRejection
reciprocalElection
reciprocalRejection
reciprocalElectionAndRejection
*/
if (typeSociogram=="reciprocalElectionAndRejection")
    reciprocalElectionAndRejection_Cx[idStudent]=x;
    
if (typeSociogram=="reciprocalElection")
    reciprocalElection_Cx[idStudent]=x;
    
if (typeSociogram=="reciprocalRejection")
    reciprocalRejection_Cx[idStudent]=x;
    
if (typeSociogram=="strongRejection")
    strongRejection_Cx[idStudent]=x;
    
if (typeSociogram=="strongElection")
    strongElection_Cx[idStudent]=x;
    
if (typeSociogram=="weakRejection")
    weakRejection_Cx[idStudent]=x;
    
if (typeSociogram=="weakElection")
    weakElection_Cx[idStudent]=x;

}


/*!
    \fn sociometricTest::getCy(QString typeSociogram)
 */
void sociometricTest::setCy(int idStudent, QString typeSociogram, int y)
{
/*
typeSociogram puede valer:
strongElection
weakElection
strongRejection
weakRejection
reciprocalElection
reciprocalRejection
reciprocalElectionAndRejection
*/
if (typeSociogram=="reciprocalElectionAndRejection")
    reciprocalElectionAndRejection_Cy[idStudent]=y;
    
if (typeSociogram=="reciprocalElection")
    reciprocalElection_Cy[idStudent]=y;
    
if (typeSociogram=="reciprocalRejection")
    reciprocalRejection_Cy[idStudent]=y;
    
if (typeSociogram=="strongRejection")
    strongRejection_Cy[idStudent]=y;
    
if (typeSociogram=="strongElection")
    strongElection_Cy[idStudent]=y;
    
if (typeSociogram=="weakRejection")
    weakRejection_Cy[idStudent]=y;
    
if (typeSociogram=="weakElection")
    weakElection_Cy[idStudent]=y;
}











/*!
    \fn sociometricTest::loadPosition(QString filename)
 */
bool sociometricTest::loadPosition(QString filename)
{
/*
typeSociogram puede valer:
strongElection
weakElection
strongRejection
weakRejection
reciprocalElection
reciprocalRejection
reciprocalElectionAndRejection
*/
Config ConfigFile(filename);
QString sn;
for (int n=1;n<=NumeroAlumnosGrupo;n++)
{
    sn = sn.setNum(n);
    ConfigFile.setGroup(sn);
    
    setCx(n,"strongElection",ConfigFile.readNumEntry("strongElection_Cx",0));
    setCy(n,"strongElection",ConfigFile.readNumEntry("strongElection_Cy",0));

    setCx(n,"weakElection",ConfigFile.readNumEntry("weakElection_Cx",0));
    setCy(n,"weakElection",ConfigFile.readNumEntry("weakElection_Cy",0));

    setCx(n,"strongRejection",ConfigFile.readNumEntry("strongRejection_Cx",0));
    setCy(n,"strongRejection",ConfigFile.readNumEntry("strongRejection_Cy",0));

    setCx(n,"weakRejection",ConfigFile.readNumEntry("weakRejection_Cx",0));
    setCy(n,"weakRejection",ConfigFile.readNumEntry("weakRejection_Cy",0));

    setCx(n,"reciprocalElection",ConfigFile.readNumEntry("reciprocalElection_Cx",0));
    setCy(n,"reciprocalElection",ConfigFile.readNumEntry("reciprocalElection_Cy",0));

    setCx(n,"reciprocalRejection",ConfigFile.readNumEntry("reciprocalRejection_Cx",0));
    setCy(n,"reciprocalRejection",ConfigFile.readNumEntry("reciprocalRejection_Cy",0));

    setCx(n,"reciprocalElectionAndRejection",ConfigFile.readNumEntry("reciprocalElectionAndRejection_Cx",0));
    setCy(n,"reciprocalElectionAndRejection",ConfigFile.readNumEntry("reciprocalElectionAndRejection_Cy",0));
}

ConfigFile.setGroup("TareasRealizadas");
setTarea("strongElection",ConfigFile.readBoolEntry("strongElection"));
setTarea("weakElection",ConfigFile.readBoolEntry("weakElection"));
setTarea("strongRejection",ConfigFile.readBoolEntry("strongRejection"));
setTarea("weakRejection",ConfigFile.readBoolEntry("weakRejection"));
setTarea("reciprocalElection",ConfigFile.readBoolEntry("reciprocalElection"));
setTarea("reciprocalRejection",ConfigFile.readBoolEntry("reciprocalRejection"));
setTarea("reciprocalElectionAndRejection",ConfigFile.readBoolEntry("reciprocalElectionAndRejection"));


return TRUE;

}




/*!
    \fn sociometricTest::getQuestion1()
 */
QString sociometricTest::getQuestion1()
{
if (CriterioSociotelico) return i18n("If a work group formed in the class, with whom would you like to work?");
else if (CriterioPsicotelico) return i18n("Choose the classmate who you would invite to your birthday celebration");
else if (CriterioAutoridad) return i18n("If you had to organize a match of a sport that you like, whom would you choose like captain?");
else if (CriterioAfinidad) return "";
else if (CriterioPropio) return Question1;
else return QString::null;

}


/*!
    \fn sociometricTest::getQuestion2()
 */
QString sociometricTest::getQuestion2()
{
if (CriterioSociotelico) return i18n("Choose the classmate who you did NOT want he/she was in your work group");
else if (CriterioPsicotelico) return i18n("Choose the classmate who you would NOT invite to your birthday celebration");
else if (CriterioAutoridad) return i18n("Choose the classmate who you would NOT want like captain for a match of a sport you like");
else if (CriterioAfinidad) return "";
else if (CriterioPropio) return Question2;
else return QString::null;
}


QString sociometricTest::getQuestion3()
{
if (CriterioSociotelico) return i18n("Guess who you think that has choosen you for his/her work group");
else if (CriterioPsicotelico) return i18n("Guess who you think that has invited you to his/her birthday celebration");
else if (CriterioAutoridad) return i18n("Guess who you think that has choosen you to be the captain for the match");
else if (CriterioAfinidad) return "";
else if (CriterioPropio) return Question3;
else return "";
}


QString sociometricTest::getQuestion4()
{
if (CriterioSociotelico) return i18n("Guess who you think that has NOT choosen you for his/her work group");
else if (CriterioPsicotelico) return i18n("Guess who you think that has NOT invited you to his/her birthday celebration");
else if (CriterioAutoridad) return i18n("Guess who you think that has NOT choosen you to be the captain for the match");
else if (CriterioAfinidad) return "";
else if (CriterioPropio) return Question4;
else return QString::null;
}


/*!
    \fn sociometricTest::numberStudentEvaluated()
 */
int sociometricTest::numberStudentsEvaluated()
{
int studentsEvaluated=0;
for (int c=1; c<=NumeroAlumnosGrupo; c++)
   {
   if (EsEvaluado[c]==TRUE) studentsEvaluated++;
   }
return studentsEvaluated;   
}


/*!
    Graba en disco el estado de los flag tareas
 */
void sociometricTest::saveTasks(QString filename)
{
Config ConfigFile(filename);
ConfigFile.setGroup("TareasRealizadas");
ConfigFile.writeEntry( "Tarea1", tarea1 );
ConfigFile.writeEntry( "Tarea2", tarea2 );
ConfigFile.writeEntry( "Tarea3", tarea3 );
ConfigFile.writeEntry( "Tarea4", tarea4 );
ConfigFile.writeEntry( "strongElection", strongElectionSociogram );
ConfigFile.writeEntry( "weakElection", weakElectionSociogram );
ConfigFile.writeEntry( "strongRejection", strongRejectionSociogram );
ConfigFile.writeEntry( "weakRejection", weakRejectionSociogram );
ConfigFile.writeEntry( "reciprocalElection", reciprocalElectionSociogram );
ConfigFile.writeEntry( "reciprocalRejection", reciprocalRejectionSociogram );
ConfigFile.writeEntry( "reciprocalElectionAndRejection", reciprocalElectionAndRejectionSociogram );
ConfigFile.write();
}



/*!
    elimina un sujeto del objeto myTest
    y tambien del fichero grabado
 */
void sociometricTest::removeStudent(int idStudent, QString filename)
{

    QString s="";
    Config ConfigFile(filename);
    ConfigFile.removeGroup(s.setNum(idStudent));
    NombreAlumno[idStudent] = QString::null;
    NumeroAlumnosGrupo--;
}


/*!
    \fn sociometricTest::newTest()
 */
void sociometricTest::newTest()
{

    //flag para test modificado del cargado de disco o inicial vaco
    isChangedTest = FALSE;



   //  propiedades generales del test
   RutaFicheroTest=QString::null;  // la ruta completa absoluta del path, terminada en /
   numeroElecciones=0;  // Numero de elecciones constanate 3 o 5 o -1
   CriterioSociotelico=FALSE;
   CriterioPsicotelico=FALSE;
   CriterioAutoridad=FALSE;
   CriterioAfinidad=FALSE;
   CriterioPropio=FALSE;
   Question1=QString::null;
   Question2=QString::null;
   Question3=QString::null;
   Question4=QString::null;
   

   // propiedades generales del grupo
   NombreInstitucion=QString::null;
   NombreTutor=QString::null;
   DescripcionGrupo=QString::null;
   IdentificativoGrupo=QString::null;
   NumeroAlumnosGrupo=0;



   // matrices para guardar la base de datos de alumnos
   //Por tanto, se crean varias
   // matrices que se gestionaran a traves de funciones de
   // de escritura y lectura, indicando siempre el index (indice)
   // del alumno que se desea procesar.
   for (int c=1;c<=99;c++) NombreAlumno[c]=QString::null;
   for (int c=1;c<=99;c++) EdadAlumno[c]=0; // int
   for (int c=1;c<=99;c++) SexoAlumno[c]=QString::null; // string
   for (int c=1;c<=99;c++) IdentificativoAlumno[c]=QString::null; //string
   
   
   //matrces para guardar las respuestas de los alumnos al cuestionario
   // siendo array[AlumnoEnEvaluacion,PosicionEleccion] = AlumnoSeleccionado
   for (int c=1;c<=99;c++) {for (int d=1;d<=99;d++) eleccion[c][d]=0; }
   for (int c=1;c<=99;c++) {for (int d=1;d<=99;d++) rechazo[c][d]=0; }
   for (int c=1;c<=99;c++) {for (int d=1;d<=99;d++) PercepcionEleccion[c][d]=0;}
   for (int c=1;c<=99;c++) {for (int d=1;d<=99;d++) PercepcionRechazo[c][d]=0;} //integer;
   
   // matrices para guardar los valores sociometricos  en general de cada alumno
   for (int c=1;c<=99;c++) Sp[c]=0; //integer; // status de elecciones
   for (int c=1;c<=99;c++) Spv[c]=0; //integer; // status de elecciones valorizadas
   for (int c=1;c<=99;c++) Sn[c]=0; //integer; // status de rechazos
   for (int c=1;c<=99;c++) Snv[c]=0; //integer; // status de rechazos valorizados
   for (int c=1;c<=99;c++) Ep[c]=0; //integer; //  expansividad positiva
   for (int c=1;c<=99;c++) En[c]=0; //integer; // expansividad negativa
   for (int c=1;c<=99;c++) Rp[c]=0; //integer; // Elecciones reciprocas
   for (int c=1;c<=99;c++) Rpv[c]=0; //integer; // Elecciones reciprocas ponderadas
   for (int c=1;c<=99;c++) Rn[c]=0; //integer; // Rechazos reciprocos
   for (int c=1;c<=99;c++) Rnv[c]=0; //integer; // Rechazos reciprocos ponderados
   for (int c=1;c<=99;c++) OS[c]=0; //integer; // Oposicion de sentimiento

   // matrices para guardar los valores sociometricos  en relacion al criterio de percepcion de cada alumno
   for (int c=1;c<=99;c++) Pp[c]=0; //integer; // percepcion de elecciones
   for (int c=1;c<=99;c++) PAp[c]=0; //integer; // percepcion acertada de elecciones
   for (int c=1;c<=99;c++) Pn[c]=0; //integer; // percepcion de rechazo
   for (int c=1;c<=99;c++) PAn[c]=0; //integer; // percepcion acertada de rechazo
   for (int c=1;c<=99;c++) Ip[c]=0; //integer; // Impresion de elecciones
   for (int c=1;c<=99;c++) In[c]=0; //integer; // Impresion de rechazos
   for (int c=1;c<=99;c++) FP[c]=0; //integer; // Falsa percepcion

   
   // indices sociometricos individuales
   for (int c=1;c<=99;c++) Pop[c]=0; // indice de popularidad
   for (int c=1;c<=99;c++) Ant[c]=0; // indice de antipatia
   for (int c=1;c<=99;c++) Expp[c]=0; // indice de expansion positiva
   for (int c=1;c<=99;c++) Expn[c]=0; // indice de expansion negativa
   for (int c=1;c<=99;c++) CA[c]=0; // indice de conexion afectiva
   for (int c=1;c<=99;c++) AP[c]=0; // indice de atencion perceptiva
   for (int c=1;c<=99;c++) RPER[c]=0; // indice de realismo perceptivo
   for (int c=1;c<=99;c++) SS[c]=0; // status sociometrico


   Param_P=0; // real;
   Param_Q=0; // real;
   Param_Med=0;  // media
   Param_Desv=0; // desviacion tipica
   Param_Asim=0; // asimetria de la curva

   
   
   

   for (int c=1;c<=99;c++) EsEvaluado[c]=FALSE; // flash para saber si un alumno ya ha sido evaluado

   
   tarea1=FALSE;
   tarea2=FALSE;
   tarea3=FALSE;
   tarea4=FALSE;
   strongElectionSociogram=FALSE;
   weakElectionSociogram=FALSE;
   strongRejectionSociogram=FALSE;
   weakRejectionSociogram=FALSE;
   reciprocalElectionSociogram=FALSE;
   reciprocalRejectionSociogram=FALSE;
   reciprocalElectionAndRejectionSociogram=FALSE;




   // guarda el valor del estudiante para el test individual sociomtrico
   studentShow=0;
   sociogramShow=QString::null;

   


    for (int c=1;c<=99;c++) reciprocalElectionAndRejection_Cx[c]=0;
    for (int c=1;c<=99;c++) reciprocalElectionAndRejection_Cy[c]=0;
    
    for (int c=1;c<=99;c++) reciprocalElection_Cx[c]=0;
    for (int c=1;c<=99;c++) reciprocalElection_Cy[c]=0;
    
    for (int c=1;c<=99;c++) reciprocalRejection_Cx[c]=0;
    for (int c=1;c<=99;c++) reciprocalRejection_Cy[c]=0;
    
    for (int c=1;c<=99;c++) strongRejection_Cx[c]=0;
    for (int c=1;c<=99;c++) strongRejection_Cy[c]=0;
    
    for (int c=1;c<=99;c++) strongElection_Cx[c]=0;
    for (int c=1;c<=99;c++) strongElection_Cy[c]=0;
    
    for (int c=1;c<=99;c++) weakRejection_Cx[c]=0;
    for (int c=1;c<=99;c++) weakRejection_Cy[c]=0;
    
    for (int c=1;c<=99;c++) weakElection_Cx[c]=0;
    for (int c=1;c<=99;c++) weakElection_Cy[c]=0;



    


    //Modo de acceso modeAccess no se reinicia


}




/*!
    \fn sociometricTest::setQuestion1(QString text)
 */
void sociometricTest::setQuestion1(QString text)
{
    Question1=text;
}


/*!
    \fn sociometricTest::setQuestion2(QString text)
 */
void sociometricTest::setQuestion2(QString text)
{
    Question2=text;
}


/*!
    \fn sociometricTest::setQuestion3(QString text)
 */
void sociometricTest::setQuestion3(QString text)
{
    Question3=text;
}


/*!
    \fn sociometricTest::setQuestion4(QString text)
 */
void sociometricTest::setQuestion4(QString text)
{
    Question4=text;
}


/*!
    alumnos que al menos tienen un nombre especificado
 */
int sociometricTest::numberStudentsInDataBase()
{
int studentsInDataBase=0;
for (int c=1; c<=NumeroAlumnosGrupo; c++)
   {
   if (NombreAlumno[c].length()!=0) studentsInDataBase++;
   }
return studentsInDataBase;   
}
