/***************************************************************************
 *   Copyright (C) 2004 by Manuel Prez Lpez                              *
 *   mapelo@ieduca.net                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef KSOCIOGRAMA_H
#define KSOCIOGRAMA_H

#include "ksociogramaWidget.h"

#include "sociometrictest.h"
#include "sociogram.h"
#include <qlabel.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <kaboutdata.h>
#include <qtoolbar.h>
#include <qpopupmenu.h>
#include <kmainwindow.h>
#include <kaction.h>

//#include "ksociogramaMainWindow.h"


class ksociograma : public frmKsociogramaWidget
{
 Q_OBJECT 
public:
  ksociograma( KMainWindow* parent=0, const char* name=0, WFlags fl=0, sociometricTest* myTest2=0, KAction *actOpenNew2=0, KAction *actOpen2=0, KAction *actSave2=0, KAction *actPrint2=0, KAction *actQuit2=0, KAction *actOpenQuestionnaire2=0);
  
  
  ~ksociograma();
  
    void closeAplication ( QCloseEvent * event );
    void questionnaireClosed();
    void showGeneralTestData();
    void showGeneralGroupData();
    void showStudentsTableData();
    void showSignificantValues();
    void showIndividualIndexsAndValues();
    void showGroupIndexs();
    void showIndividualSociograms();
    void showGroupSociograms();
  
    void loadTest();
    void newTest();
    bool saveTest();
    void openQuestionnaire();
        
    
    
    
    
    void printTest();
    void newAccess();

    
    KAction *actOpenNew;
    KAction *actOpen;
    KAction *actSave;
    KAction *actPrint;
    KAction *actQuit;
    KAction *actOpenQuestionnaire;
    

  
  /*$PUBLIC_FUNCTIONS$*/

public slots:
  /*$PUBLIC_SLOTS$*/
    virtual void slotStudentTableClicked(int,int,int,const QPoint &);
    virtual void slotUpdateStudent();
    virtual void slotDoAbbreviation(const QString &);
    virtual void slotCustomItems(int);
    virtual void slotStudentSelected(int);
    virtual void slotSociometricParameterSelected(int);
    virtual void slotIndividualSociometricValueSelected(int idStudent);
    virtual void slotGroupSociogramSelected(int);
    virtual void slotChangeCriterion(int idRadioButton);
    virtual void slotChangeNumberElection(int idRadioButton);
    virtual void slotChangeQuestion1(const QString &text);
    virtual void slotChangeQuestion2(const QString &text);
    virtual void slotChangeQuestion3(const QString &text);
    virtual void slotChangeQuestion4(const QString &text);
    virtual void slotChangeNameInstitution(const QString &nameInstitution);
    virtual void slotChangeNameTeacher(const QString &nameTeacher);
    virtual void slotChangeGroupId(const QString &groupId);
    virtual void slotChangeNumberStudents(const QString &numberStudents);
    virtual void slotChangeGroupDescription(const QString &groupDescription);
    virtual void slotAccess();
    virtual void slotChangeModeAccess(int modeAccess);
                     


protected:
  /*$PROTECTED_FUNCTIONS$*/


protected slots:
  /*$PROTECTED_SLOTS$*/
  
private:
sociometricTest *myTest;

sociogram *individualSociogram;
sociogram *groupSociogram;

QLabel *label1TabPage7;
QComboBox *comboBox1TabPage7;
QPushButton *button1TabPage7;
QPushButton *button2TabPage7;

QLabel *label1TabPage8;
QComboBox *comboBox1TabPage8;
QPushButton *button1TabPage8;
QPushButton *button2TabPage8;


KMainWindow* parent;
    QPainter  *myPainterSociogramIndividual;
    QPainter  *myPainterSociogramGroup;






protected slots:
    

private:
    void disableWidgets();
    void setTasksAndPages();
private:
    void printAllIndividualSociogram();
    void printAllGroupSociogram();
};

#endif

