/***************************************************************************
 *   Copyright (C) 2004-2007 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#ifndef PROTOCOLNAME_H
#define PROTOCOLNAME_H

#define TCP_NUM 1
#define UDP_NUM 2
#define DDP_NUM 4

#include <netinet/in.h>

#include <qstring.h>
#include <qptrlist.h>

/**
@author Giovanni Venturi
*/

class PortName
{
  public:
    PortName(QString portName, int portNumber, short tcp_udp)
      : m_name( portName ), m_number( portNumber ), m_tcpUdp( tcp_udp )
    {}

    QString name() const { return m_name; }
    int number() const { return m_number; }
    short tcpUdpState() const { return m_tcpUdp; }
    void addTcpUdpState( short state ) { m_tcpUdp |= state; }

  private:
    QString m_name;
    int m_number;
    short m_tcpUdp;  // TCP_NUM: 1 -> tcp, UDP_NUM: 2 -> udp, DDP_NUM: 4 -> ddp
};

class ProtocolNameList
{
  public:
    ProtocolNameList();
    ~ProtocolNameList();

    QString detectProtocol( uint16_t const& proto );
    bool isTCP( uint16_t const& proto );
    bool isUDP( uint16_t const& proto );
    bool isDDP( uint16_t const& proto );

  private:
    QString m_protocolName;
    QPtrList<PortName> m_portData;

  private:
    void parseServicesFile();
};

#endif
