/***************************************************************************
 *   Copyright (C) 2004-2007 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#include <unistd.h>
#include <sys/types.h>

#include <kuniqueapplication.h>
#include <dcopclient.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kstandarddirs.h>

#include "ksniffer.h"
#include "version.h"

static const char description[] =
  I18N_NOOP("A KDE application for sniffing your computer network");

static const char version[] = APPVER;

static KCmdLineOptions options[] =
{
  //{ "+[URL]", I18N_NOOP( "Document to open" ), 0 },
  KCmdLineLastOption
};

int main(int argc, char **argv)
{
  KAboutData about("ksniffer", "KSniffer", version, description,
                   KAboutData::License_GPL, "(C) 2004-2007 Giovanni Venturi");
  //about.addAuthor( "Giovanni Venturi", 0, "giovanni@ksniffer.org" );
  about.addAuthor( "Giovanni Venturi", I18N_NOOP("Original author and core developer"), "giovanni@ksniffer.org", "http://www.ksniffer.org/" );
  about.addCredit( "Alexander Neundorf", I18N_NOOP("The code for detecting network devices"), "neundorf@kde.org" );
  about.addCredit( I18N_NOOP("Gerald Combs and all Ethereal authors"),
    I18N_NOOP("A good sniffer application has to take a look at this great huge application"), "", "http://www.ethereal.com/" );
  about.addCredit( "Carmine De Rosa", I18N_NOOP("KSniffer icon and splash screen"), "dslaky@gmail.com");

  KCmdLineArgs::init(argc, argv, &about);
  KCmdLineArgs::addCmdLineOptions(options);
  KUniqueApplication app;

  // libpcap library to sniff network needs root privileges
  struct stat statbuf;
  QString ksniffPath = KStandardDirs::findExe("ksniff");
  if (ksniffPath.isEmpty())
  {
    KMessageBox::sorry(0L, i18n("<p>The 'ksniff' executable was not found in your PATH<br>"
        "environment. You need it to capture packets.<br><br>" \
        "Your installation is not correct.</p>"));
    return -1;
  }

  if (lstat(ksniffPath.ascii(), &statbuf) == -1)
  {
    KMessageBox::sorry(0L, i18n("<p>Cannot determine the 'ksniff' executable properties.<br>" \
                               "Your installation is not correct.</p>"));
    return -1;
  }

  if ((S_ISUID & statbuf.st_mode) != S_ISUID)
  {
    KMessageBox::sorry(0L, i18n("<p>The 'ksniff' executable needs root privileges to capture packets.<br>" \
                               "Your installation is not correct.</p>"));
    return -1;
  }

  // register ourselves as a dcop client
  app.dcopClient()->registerAs(app.name(), false);

  KSniffer *mainWidget = 0;

  // see if we are starting with session management
  if (app.isRestored())
  {
    RESTORE(KSniffer);
  }
  else
  {
    // no session... just start up normally
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
    if (args->count() == 0)
    {
      mainWidget = new KSniffer();
      app.setMainWidget( mainWidget );
      mainWidget->show();
    }
    else
    {
      int i = 0;
      for (; i < args->count(); i++)
      {
        mainWidget = new KSniffer();
        mainWidget->show();
        mainWidget->load(args->url(i));
      }
    }
    args->clear();
  }

  return app.exec();
}
