/***************************************************************************
 *   Copyright (C) 2004-2008 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#include <qstringlist.h>
#include <qfile.h>
#include <qtextstream.h>

#include "portnumbernamelist.h"

PortNumberNameList::PortNumberNameList()
{
  // parse Services File
  // The complete update file is available here:
  //   http://www.iana.org/assignments/port-numbers
  QFile file( "/etc/services" );

  if ( file.open( IO_ReadOnly ) )
  {
    QTextStream stream( &file );
    QString line;

    while ( !stream.atEnd() )
    {
      line = QString::fromLocal8Bit(stream.readLine().ascii()).simplifyWhiteSpace();

      if (line.startsWith("#"))
        continue;
      QStringList params = QStringList::split( ' ', line );

      if (params.count() < 2)
        continue;

      QStringList protocol = QStringList::split( '/', params[1] );

      if (protocol.count() < 2)
        continue;

      if (protocol[1] == "ddp")
        //pnn.addDPPState();
        // we don't need DDP protocol
        continue;

      if (!m_portNumber[protocol[0].toUInt()].name().isEmpty())
      {
        if (protocol[1] == "udp")
          m_portNumber[protocol[0].toUInt()].addUDPState();
        else if (protocol[1] == "tcp")
          m_portNumber[protocol[0].toUInt()].addTCPState();
      }
      else
      {
        PortNumberName pnn( params[0] );
        if (protocol[1] == "udp")
          pnn.addUDPState();
        else if (protocol[1] == "tcp")
          pnn.addTCPState();
        m_portNumber[protocol[0].toUInt()] = pnn;
      }
    }
    file.close();
  }
}


QString PortNumberNameList::detectPortNumberName( uint16_t const& proto )
{
  return m_portNumber[ proto ].name();
}


bool PortNumberNameList::isTCP( uint16_t const& proto )
{
  return ( (m_portNumber[ proto ].protocolType() & TCP_TYPE) == TCP_TYPE );
}


bool PortNumberNameList::isUDP( uint16_t const& proto )
{
  return ( (m_portNumber[ proto ].protocolType() & UDP_TYPE) == UDP_TYPE );
}


bool PortNumberNameList::isDDP( uint16_t const& proto )
{
  return ( (m_portNumber[ proto ].protocolType() & DDP_TYPE) == DDP_TYPE );
}
