/***************************************************************************
 *   Copyright (C) 2004-2008 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#ifndef KINFOIP_H
#define KINFOIP_H

#include <kpopupmenu.h>

#define WHOIS_CMD       1
#define TRACEROUT_CMD   2
#define PING_CMD        3
#define DIG_CMD         4
#define HOST_CMD        5
#define NSLOOKUP_CMD    6

class QString;

class KProcess;
class DisplayData;

class KInfoIP : public QObject
{
  Q_OBJECT

  public:
    KInfoIP();
    ~KInfoIP();

    KPopupMenu *createPopupMenu();
    bool manageIP( const QString& ip );

  private:
    QString m_stdoutString;
    QString m_IP;
    QString m_whoisExec;
    QString m_tracerouteExec;
    QString m_pingExec;
    QString m_digExec;
    QString m_hostExec;
    QString m_nslookupExec;
    KPopupMenu *m_popupMenu;
    DisplayData *m_displayDataBox;
    bool m_buttonCancel;
    KProcess *m_cmd;
    int m_idApplication;

  private slots:
    void gotMessage( KProcess *proc, char *buffer, int buflen );
    void commandExited();
    void showData( int id );
    void okCancelClicked();
};

#endif  // KINFOIP_H
