/***************************************************************************
 *   Copyright (C) 2004-2008 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#ifndef FRAMEHEADERMANAGER_H
#define FRAMEHEADERMANAGER_H

class Packet;
class QStringList;

#include "../packetstructures.h"

class FrameHeaderManager
{
  public:
    FrameHeaderManager(ptrPacketType packet);

    QString strType() const;  // give the corrispondent string of the frame type
    QString sorceAddress() const;
    QString destinationAddress() const;

    QStringList headerLines() const;
    unsigned short protocol() const;

  private:
    Packet *m_packet;
};

#endif
