//
// C++ Interface: types
//
// Description:
// All specail types for KShowMail
//
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef TYPES_H
#define TYPES_H

//Qt headers
#include <qvaluelist.h>
#include <qmap.h>

/**
 * All special types for KShowMail.
 */
namespace Types
{
     /**
      * State of the application during running time.
      */
     enum State_Type {idle,                  /**<it's doing nothing*/

                      deleting,              /**<it's deleting a message on the server*/

                      configure,             /**<the user is configuring the application or
                                              * the mail or just the header of the mail is
                                              * being shown*/

                      executing,             /**<a command on the command list is being executed*/

                      showing,               /**<it's downloading and showing a mail*/

                      refreshing             /**<it's refreshing the mail lists*/
     };

     /**
      * State of an account.
      */
     enum AccountState_Type
     {
       AccountIdle,         /**<it's doing nothing*/

       AccountDeleting,     /**<a deletion is running*/

       AccountDownloading,  /**<the account is downloading mail bodies*/

       AccountRefreshing    /**<the account is refreshing its mail list*/
     };

     /**
      * List of mail numbers. It is a QValueList of integers.
      */
     typedef QValueList<int> MailNumberList_Type;

     /**
      * Map to notice which accounts need to get an order to do a task.
      * The Key is the account name and the data a boolean.
      * TRUE means the task was ordered, FALSE the task was ended.
      */
     typedef QMap<QString, bool> AccountTaskMap_Type;


}

#endif
