/***********************************************************************
*                                                                      *
*               This software is part of the ast package               *
*           Copyright (c) 1989-2007 AT&T Knowledge Ventures            *
*                      and is licensed under the                       *
*                  Common Public License, Version 1.0                  *
*                      by AT&T Knowledge Ventures                      *
*                                                                      *
*                A copy of the License is available at                 *
*            http://www.opensource.org/licenses/cpl1.0.txt             *
*         (with md5 checksum 059e8cd6165cb4c31e351f2b69388fd9)         *
*                                                                      *
*              Information and Software Systems Research               *
*                            AT&T Research                             *
*                           Florham Park NJ                            *
*                                                                      *
*                 Glenn Fowler <gsf@research.att.com>                  *
*                  David Korn <dgk@research.att.com>                   *
*                   Eduardo Krell <ekrell@adexus.cl>                   *
*                                                                      *
***********************************************************************/
#pragma prototyped

#include "3d.h"

#include <cs.h>

/*
 * peek siz chars from fd into buf
 * if not peekable but seekable then chars are peeked at offset 0
 */

ssize_t
peek(int fd, void* buf, size_t siz)
{
	register int	n;

	n = cspeek(&cs, fd, buf, siz);
	if (n >= 0)
		return(n);
	cspeek(&cs, -1, NiL, 0);
	if (!FSTAT(fd, &state.path.st) && state.path.st.st_size <= siz)
	{
		while ((n = read(fd, buf, siz)) != state.path.st.st_size && lseek(fd, 0L, 1) > 0 && lseek(fd, 0L, 0) == 0);
		if (n == state.path.st.st_size || n > 0 && !state.path.st.st_size)
			return(n);
	}
	return(-1);
}
