/***************************************************************************
                          wucalendardialog.cpp  -  description
                             -------------------
    begin                : Sun Aug 5 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qbuttongroup.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qspinbox.h>

#include <kiconloader.h>
#include <klocale.h>
#include <kpushbutton.h>

#include "wucalendar.h"

#include "wucalendardialog.h"

WUCalendarDialog::WUCalendarDialog(int wus, int increment, const char *name)
                 : QWidget(0, name, WStyle_Customize | WStyle_DialogBorder | WStyle_Dialog)
{
	setCaption(i18n("Work Units Calendar"));

	QBoxLayout *layout = new QVBoxLayout(this);
	layout->setMargin(8);
	layout->setSpacing(8);

	WUCalendar *calendar = new WUCalendar(wus, this, "WUCalendarDialog::calendar");
	calendar->setWUIncrement(increment);
	layout->addWidget(calendar, 1);

	QBoxLayout *hbox = new QHBoxLayout(layout);
	hbox->setSpacing(4);

	QButtonGroup *group = new QButtonGroup(this);
	group->hide();

	KIconLoader loader;
	KPushButton *button;

	button = new KPushButton(this);
	button->setPixmap(loader.loadIcon("2leftarrow", KIcon::Small));
	hbox->addWidget(button, 0);
	group->insert(button, 0);

	button = new KPushButton(this);
	button->setPixmap(loader.loadIcon("1leftarrow", KIcon::Small));
	hbox->addWidget(button,0);
	group->insert(button, 5);

	hbox->addStretch(1);

	hbox->addWidget(new QLabel(i18n("Work units per day:"), this));

	QSpinBox *edit = new QSpinBox(0, 9999, 1, this, "WUCalendarDialog::increment");
	edit->setValue(increment);
	hbox->addWidget(edit, 0);

	hbox->addStretch(1);

	button = new KPushButton(this);
	button->setPixmap(loader.loadIcon("1rightarrow", KIcon::Small));
	hbox->addWidget(button, 0);
	group->insert(button, 7);

	button = new KPushButton(this);
	button->setPixmap(loader.loadIcon("2rightarrow", KIcon::Small));
	hbox->addWidget(button, 0);
	group->insert(button, 12);

	connect(group, SIGNAL(clicked(int)), this, SLOT(handleButtons(int)));
	connect(edit, SIGNAL(valueChanged(int)), this, SLOT(handleWUIncrement(int)));
}

WUCalendarDialog::~WUCalendarDialog()
{
}

int WUCalendarDialog::startWUs()
{
	WUCalendar *calendar = (WUCalendar *) child("WUCalendarDialog::calendar", "WUCalendar");
	return(calendar->startWUs());
}

double WUCalendarDialog::wuIncrement()
{
	WUCalendar *calendar = (WUCalendar *) child("WUCalendarDialog::calendar", "WUCalendar");
	return(calendar->wuIncrement());
}

void WUCalendarDialog::setStartWUs(int wus)
{
	WUCalendar *calendar = (WUCalendar *) child("WUCalendarDialog::calendar", "WUCalendar");
	calendar->setStartWUs(wus);
}

void WUCalendarDialog::setWUIncrement(int inc)
{
	QSpinBox *edit = (QSpinBox *) child("WUCalendarDialog::increment", "QSpinBox");
	edit->setValue(inc);
}

void WUCalendarDialog::setLogData(const QValueList<log_data>& data)
{
	WUCalendar *calendar = (WUCalendar *) child("WUCalendarDialog::calendar", "WUCalendar");
	calendar->setLogData(data);
}

void WUCalendarDialog::handleButtons(int id)
{
	WUCalendar *calendar = (WUCalendar *) child("WUCalendarDialog::calendar", "WUCalendar");
	calendar->addMonths(id - 6);
}

void WUCalendarDialog::handleWUIncrement(int inc)
{
	WUCalendar *calendar = (WUCalendar *) child("WUCalendarDialog::calendar", "WUCalendar");
	calendar->setWUIncrement(inc);
}

#include "wucalendardialog.moc"

