/***************************************************************************
                          userstatsview.h  -  description
                             -------------------
    begin                : Wed May 30 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef USERSTATSVIEW_H
#define USERSTATSVIEW_H

#include <qstring.h>

#include "ksetispyview.h"
#include "wucalendardialog.h"

class UserStatsView : public KSetiSpyView {
  Q_OBJECT
  public:
    UserStatsView(QWidget *parent=0, const char *name=0);
    ~UserStatsView();
  public slots:
    virtual void saveConfig(bool saveGeometry);
    virtual void readConfig(bool readGeometry);
  protected:
    virtual void updateContent(bool force);
  protected slots:
    virtual void updateLog();
  private:
    bool messageVisible();
    void checkAnniversary(const QDate& registered);
    int findCountry(const QString& country) const;
    QString formatVenue(int venue) const;
    user_stats *stats;
    int anniversary;
    WUCalendarDialog *calendar;
  private slots:
    void showMessage(const QString& msg);
    void showMain();
    void updateUserStats();
    void handleURL(const QString& url);
    void handleUserStatsUpdates(const user_stats* current);
};

#endif
