/***************************************************************************
                          statsserversdialog.cpp  -  description
                             -------------------
    begin                : Thu Jul 25 2002
    copyright            : (C) 2002 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qradiobutton.h>

#include <kiconloader.h>
#include <klocale.h>
#include <kpushbutton.h>

#include "statsserversdialog.h"

const QString StatsURLPixmaps[N_STATS_URLS] =
{
  "ksetispy_user_data",
  "ksetispy_user_link",
  "ksetispy_group_data",
  "ksetispy_group_link",
  "ksetispy_certificate_link"
};

const int N_CGI_HOSTS = 3;

const QString CGIHosts[N_CGI_HOSTS] =
{
  "setiathome2.ssl.berkeley.edu",
  "setiathome.ssl.berkeley.edu",
  "iosef.ssl.berkeley.edu"
};

const int N_CGI_PATHS = 3;

const QString CGIPaths[N_CGI_PATHS] =
{
  "/cgi-bin/cgi",
  "/cgi-bin/cgi2",
  "/fcgi-bin/fcgi"
};

StatsServersDialog::StatsServersDialog(QWidget *parent, const char *name)
                   : KDialog(parent, name, true)
{
  setCaption(i18n("Stats Servers"));
  setMaximumSize(0, 0);

  QBoxLayout *layout = new QVBoxLayout(this, 8, 8);

  layout->addSpacing(8);

  {
    // Header

    QBoxLayout *hbox = new QHBoxLayout(layout);

    hbox->addSpacing(8);

    iconLabel = new QLabel(this, "StatsServersDialog::icon");
    hbox->addWidget(iconLabel);

    hbox->addStretch(1);

    typeCombo = new KComboBox(this, "StatsServersDialog::type");
    hbox->addWidget(typeCombo);

    typeCombo->insertItem(i18n("User Data"));
    typeCombo->insertItem(i18n("User Link"));
    typeCombo->insertItem(i18n("Group Data"));
    typeCombo->insertItem(i18n("Group Link"));
    typeCombo->insertItem(i18n("Certificate Link"));

    connect(typeCombo, SIGNAL(activated(int)), this, SLOT(setType(int)));

    hbox->addStretch(1);
  }

  layout->addSpacing(8);

  {

    // Main

    QRadioButton *radio;
    QBoxLayout *hbox;

    locationGroup = new QButtonGroup(this, "StatsServersDialog::location");
    locationGroup->hide();

    connect(locationGroup, SIGNAL(clicked(int)), this, SLOT(handleLocation(int)));

    radio = new QRadioButton(i18n("Use the &SETI@home CGI server"), this, "StatsServersDialog::seti_cgi");
    layout->addWidget(radio);

    locationGroup->insert(radio, 0);

    hbox = new QHBoxLayout(layout);

    hbox->addSpacing(24);

    hbox->addWidget(new QLabel(i18n("Host:"), this));

    hostCombo = new KComboBox(true, this, "StatsServersDialog::host");
    hbox->addWidget(hostCombo, 1);

    hostCombo->setDuplicatesEnabled(false);
    for(int i = 0; i < N_CGI_HOSTS; i++)
      hostCombo->insertItem(CGIHosts[i]);

    hbox = new QHBoxLayout(layout);

    hbox->addSpacing(24);

    hbox->addWidget(new QLabel(i18n("Path:"), this));

    pathCombo = new KComboBox(true, this, "StatsServersDialog::path");
    hbox->addWidget(pathCombo);

    pathCombo->setDuplicatesEnabled(false);

    hbox->addStretch(1);

    hbox = new QHBoxLayout(layout);

    hbox->addSpacing(24);

    hbox->addWidget(new QLabel(i18n("Command:"), this));

    commandEdit = new KLineEdit(this, "StatsServersDialog::command");
    hbox->addWidget(commandEdit, 1);

    radio = new QRadioButton(i18n("Use a custom &web page"), this, "StatsServersDialog::seti_cgi");
    layout->addWidget(radio);

    locationGroup->insert(radio, 1);

    hbox = new QHBoxLayout(layout);

    hbox->addSpacing(24);

    hbox->addWidget(new QLabel(i18n("URL:"), this));

    urlEdit = new KLineEdit(this, "StatsServersDialog::url");
    hbox->addWidget(urlEdit, 1);
  }

  layout->addSpacing(8);
  layout->addStretch(1);

  {

    // OK/Cancel buttons

    QBoxLayout *hbox = new QHBoxLayout(layout);

    hbox->addStretch(1);

    KPushButton *okButton = new KPushButton(i18n("&OK"), this, "StatsServersDialog::OK");
    hbox->addWidget(okButton);

    okButton->setDefault(true);

    KPushButton *cancelButton = new KPushButton(i18n("&Cancel"), this, "StatsServersDialog::cancel");
    hbox->addWidget(cancelButton);

    connect(cancelButton, SIGNAL(clicked()), this, SLOT(reject()));
    connect(okButton, SIGNAL(clicked()), this, SLOT(accept()));
  }

  statsType = 0;
  setType(0);
  setCurrentStatsURL(data[0]);
}

StatsServersDialog::~StatsServersDialog()
{
}

statsURLStruct StatsServersDialog::statsURL(KSetiSpyDoc::StatsURLType type) const
{
  if(type == statsType)
    return currentStatsURL();

  return data[type];
}

void StatsServersDialog::setStatsURL(KSetiSpyDoc::StatsURLType type, statsURLStruct datum)
{
  if(type < 0 || type > N_STATS_URLS) return;
  
  data[type] = datum;

  if(type == statsType)
    setCurrentStatsURL(datum);
}

int StatsServersDialog::type() const
{
  return statsType;
}

void StatsServersDialog::setType(int type)
{
  // change the icon and menu entry

  const QPixmap pixmap =
    KIconLoader().loadIcon(StatsURLPixmaps[type], KIcon::NoGroup, KIcon::SizeLarge);
  iconLabel->setPixmap(pixmap);

  if(statsType != type)
  {
    // first, save the current settings

    data[statsType] = currentStatsURL();

    // change the menu entry

    if(typeCombo->currentItem() != type)
      typeCombo->setCurrentItem(type);

    // assign the new current settings

    statsType = type;
    setCurrentStatsURL(data[type]);
  }
}

statsURLStruct StatsServersDialog::currentStatsURL() const
{
  statsURLStruct out;

  out.custom = isCustom();
  out.host = host();
  out.path = path();
  out.command = command();
  out.URL = URL();

  return out;
}

void StatsServersDialog::setCurrentStatsURL(const statsURLStruct& datum)
{
  setHost(datum.host);
  setPath(datum.path);
  setCommand(datum.command);
  setURL(datum.URL);
  setCustom(datum.custom);
}

bool StatsServersDialog::isCustom() const
{
  return(locationGroup->id(locationGroup->selected()) == 1);
}

void StatsServersDialog::setCustom(bool set)
{
  locationGroup->setButton(set ? 1 : 0);

  // enable/disable the appropriate widgets

  hostCombo->setEnabled(!set);
  pathCombo->setEnabled(!set);
  commandEdit->setEnabled(!set);
  urlEdit->setEnabled(set);
}

QString StatsServersDialog::host() const
{
  return hostCombo->currentText();
}

void StatsServersDialog::setHost(const QString& host)
{
  int id = N_CGI_HOSTS;

  hostCombo->clear();
  for(int i = 0; i < N_CGI_HOSTS; i++) {
    hostCombo->insertItem(CGIHosts[i]);
    if(CGIHosts[i] == host) id = i;
  }

  if(id == N_CGI_HOSTS)
    hostCombo->insertItem(host);

  hostCombo->setCurrentItem(id);
}

QString StatsServersDialog::path() const
{
  return pathCombo->currentText();
}

void StatsServersDialog::setPath(const QString& path)
{
  int id = N_CGI_PATHS;

  pathCombo->clear();
  for(int i = 0; i < N_CGI_PATHS; i++) {
    pathCombo->insertItem(CGIPaths[i]);
    if(CGIPaths[i] == path) id = i;
  }

  if(id == N_CGI_PATHS)
    pathCombo->insertItem(path);

  pathCombo->setCurrentItem(id);
}

QString StatsServersDialog::command() const
{
  return commandEdit->text();
}

void StatsServersDialog::setCommand(const QString& command)
{
  commandEdit->setText(command);
}

QString StatsServersDialog::URL() const
{
  return urlEdit->text();
}

void StatsServersDialog::setURL(const QString& URL)
{
  urlEdit->setText(URL);
}

void StatsServersDialog::handleLocation(int location)
{
  setCustom(location == 1);
}

#include "statsserversdialog.moc"

