/***************************************************************************
                          signalplot.h  -  description
                             -------------------
    begin                : Sat Jun 2 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SIGNALPLOT_H
#define SIGNALPLOT_H

#include <qvaluelist.h>
#include <qwidget.h>

#include "setidata.h"

const QSize DefaultPlotSize  = QSize(345, 170);
const QSize SetiPlotSize    = QSize(414, 97);

class SignalPlot : public QWidget {
  Q_OBJECT
  public:
    SignalPlot(QWidget *parent=0, const char *name=0, WFlags f=0);
    ~SignalPlot();
  public slots:
    void clearData();
    void setData(const gaussian_summary& gaussian);
    void setData(const pulse_summary& pulse);
    void setData(const wu_info& wu);
  protected:
    void paintEvent(QPaintEvent *);
    enum {NoData, Gaussian, Pulse, TelescopePath} type;
    struct {gaussian_summary gaussian; pulse_summary pulse; wu_info wu; } data;
  private:
    void computeBoundaries(const QValueList<double>& list, double& min, double& max);
    void arrow(QPainter *painter, int x1, int y1, int x2, int y2);
};

#endif
