/***************************************************************************
                          setidatamonitor.h  -  description
                             -------------------
    begin                : Sun Jun 17 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SETIDATAMONITOR_H
#define SETIDATAMONITOR_H

#include <qstring.h>
#include <qvaluelist.h>

#include "datamonitor.h"
#include "setidata.h"

const QString state_file        = "state.sah";
const QString user_info_file    = "user_info.sah";
const QString work_unit_file    = "work_unit.sah";
const QString version_file      = "version.sah";
const QString output_file       = "outfile.sah";
const QString result_file        = "result.sah";
const QString wtemp_file        = "wtemp.sah";

class SetiDataMonitor : public DataMonitor {
  Q_OBJECT
  public:
    enum State {No_Data, No_WU, Loading, Idle, Running};
    SetiDataMonitor(const KURL& setiURL, QObject *parent=0, const char *name=0);
    ~SetiDataMonitor();
    int clientTimeOut() const;
    State currentState() const;
    const seti_data *setiData();
    double percentLoaded() const;
    static double teraFLOPs(const seti_data& data);
    static QString timeToString(double secs);
    static QString raToString(double ra);
    static QString decToString(double dec, bool sign=true);
    static double resolution(int fft_length);
    static double score(const spike_summary& summary);
    static double score(const gaussian_summary& summary);
    static double score(const pulse_summary& summary);
    static double score(const triplet_summary& summary);
    static double signalRatio(const spike_summary& summary);
    static double signalRatio(const gaussian_summary& summary);
    spike_summary toSummary(const spike_detail& detail) const;
    gaussian_summary toSummary(const gaussian_detail& detail) const;
    pulse_summary toSummary(const pulse_detail& detail) const;
    triplet_summary toSummary(const triplet_detail& detail) const;
    static bool isInteresting(const gaussian_detail& gaussian);
    static bool isInteresting(const gaussian_summary& gaussian);
    static bool parseVersionLines(DataMonitor *monitor, QStringList& lines, version_info& result);
    static bool parseUserInfoLines(DataMonitor *monitor, QStringList& lines, user_info& result);
    static bool parseWorkUnitLines(DataMonitor *monitor, QStringList& lines, wu_info& result);
    static bool parseStateLines(DataMonitor *monitor, QStringList& lines, state_info& result);
    static QDateTime convertToDate(double n);
    static QDateTime convertToDate(const QString &str, double *date=NULL);
  public slots:
    virtual void setClientTimeOut(int secs);
  signals:
    void updated(QObject *sender);
  protected:
    virtual bool parseFile(int index, const QString& fileName);
    int state_index, user_info_index, work_unit_index,
        version_index, output_index, wtemp_index, result_index;
    State state;
    seti_data data;
    QDateTime lastModified;
    double loaded;
  protected slots:
    virtual void updateData();
    virtual void checkState();
  private:
    bool parseVersionFile(const QString& fileName);
    bool parseUserInfoFile(const QString& fileName);
    bool parseWorkUnitFile(const QString& fileName);
    bool parseStateFile(const QString& fileName);
    bool parseOutputFile(const QString& fileName);
    bool parseWUTempFile(const QString& fileName);
    int timeout;
    QTimer *timer;
};

#endif
