/***************************************************************************
                          resultsdetailtable.cpp  -  description
                             -------------------
    begin                : Sun Jun 24 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qclipboard.h>
#include <qlayout.h>

#include <kapplication.h>
#include <klocale.h>

#include "resultspikeitem.h"
#include "resulttripletitem.h"

#include "resultsdetailtable.h"

ResultsDetailTable::ResultsDetailTable(Type type, QWidget *parent, const char *name)
                   : KSetiSpyView(Text, parent, name)
{
  QBoxLayout *layout = new QVBoxLayout(this);

  KListView *resultItemList = new KListView(this, "ResultsDetailTable::list");
  resultItemList->setSelectionMode(QListView::NoSelection);
  resultItemList->setShowSortIndicator(true);
  layout->addWidget(resultItemList, 1);

  if(type == Spike)
  {
    resultItemList->addColumn(i18n("Spike"));
    resultItemList->addColumn(i18n("Power"));
    resultItemList->addColumn(i18n("Score"));
    resultItemList->addColumn(i18n("Signal ratio"));
    resultItemList->addColumn(i18n("Resolution"));
    resultItemList->addColumn(i18n("Frequency"));
    resultItemList->addColumn(i18n("Time"));
    resultItemList->addColumn(i18n("Drift rate"));
  }
  else
  {
    resultItemList->addColumn(i18n("Triplet"));
    resultItemList->addColumn(i18n("Power"));
    resultItemList->addColumn(i18n("Score"));
    resultItemList->addColumn(i18n("Period"));
    resultItemList->addColumn(i18n("Resolution"));
    resultItemList->addColumn(i18n("Frequency"));
    resultItemList->addColumn(i18n("Time"));
    resultItemList->addColumn(i18n("Drift rate"));
  }

  connect(resultItemList, SIGNAL(contextMenu(KListView *, QListViewItem *, const QPoint &)),
          this, SLOT(handleContextMenu(KListView*, QListViewItem*, const QPoint &)));

  this->type = type;

  updateContent();
}

ResultsDetailTable::~ResultsDetailTable()
{
}

void ResultsDetailTable::readConfig(bool)
{
  KConfig *config = kapp->config();

  config->setGroup((type == Spike) ? "Spikes Table" : "Triplets Table");

  KListView *resultItemList = (KListView *) child("ResultsDetailTable::list", "KListView");
  QValueList<int> l = config->readIntListEntry("Column widths");
  for(uint i = 0; i < l.count(); i++)
    resultItemList->setColumnWidth(i, l[i]);
}

void ResultsDetailTable::saveConfig(bool)
{
  KConfig *config = kapp->config();

  config->setGroup((type == Spike) ? "Spikes Table" : "Triplets Table");

  KListView *resultItemList = (KListView *) child("ResultsDetailTable::list", "KListView");
  QValueList<int> l;
  for(int i = 0; i < resultItemList->columns(); i++)
    l.append(resultItemList->columnWidth(i));
  config->writeEntry("Column widths", l);
}

void ResultsDetailTable::updateContent()
{
  KListView *resultItemList = (KListView *) child("ResultsDetailTable::list", "KListView");

  resultItemList->clear();

  SetiClientMonitor *monitor = kdoc->setiMonitor();
  if(monitor == NULL) return;

  const SetiClientMonitor::State state = monitor->currentState();

  if(state < SetiClientMonitor::Idle) return;

  const seti_data *data = monitor->setiData();

  if(type == Spike)
  {
    if(data->state.best_spike.score > 0.0) {
      new ResultSpikeItem(resultItemList, i18n("Best score"), monitor->toSummary(data->state.best_spike));

      for(uint i = 0; i < data->output.spikes.count(); i++)
        new ResultSpikeItem(resultItemList, i18n("Returned %1").arg(i+1), data->output.spikes[i]);
    }
  }
  else
  {
    if(data->state.best_triplet.score > 0.0) {
      new ResultTripletItem(resultItemList, i18n("Best score"), monitor->toSummary(data->state.best_triplet));

      for(uint i = 0; i < data->output.triplets.count(); i++)
        new ResultTripletItem(resultItemList, i18n("Returned %1").arg(i+1), data->output.triplets[i]);
    }
  }
}

void ResultsDetailTable::handleContextMenu(KListView *, QListViewItem *, const QPoint& p)
{
  popup->popup(p);
}

void ResultsDetailTable::textToClipboard()
{
  QString out;

  KListView *resultItemList = (KListView *) child("ResultsDetailTable::list", "KListView");

  for(int i = 0; i < resultItemList->columns(); i++)
  {
    if(i > 0) out += "\t";
    out += resultItemList->columnText(i);
  }
  out+= "\n";

  for(QListViewItem *resultItem = resultItemList->firstChild();
      resultItem != NULL;
      resultItem = resultItem->nextSibling())
  {
    for(int i = 0; i < resultItemList->columns(); i++)
    {
      if(i > 0) out += "\t";
      out += resultItem->text(i);
    }
    out+= "\n";
  }

  KApplication::clipboard()->setText(out);
}

#include "resultsdetailtable.moc"

