/***************************************************************************
                          processorview.cpp  -  description
                             -------------------
    begin                : Wed May 30 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qwidgetstack.h>

#include <kcombobox.h>
#include <kglobal.h>
#include <klocale.h>
#include <kpushbutton.h>

#include "processorview.h"

ProcessorView::ProcessorView(QWidget *parent, const char *name)
              : KSetiSpyView(Text, parent, name)
{
  QBoxLayout *hbox;

  QBoxLayout *layout = new QBoxLayout(this, QBoxLayout::TopToBottom);
  layout->setSpacing(8);

  hbox = new QHBoxLayout(layout);

  hbox->addStretch(1);

  KComboBox *cpuMenu = new KComboBox(this, "ProcessorView::cpu_menu");
  hbox->addWidget(cpuMenu);
  connect(cpuMenu, SIGNAL(activated(int)), this, SLOT(handleMenuActivated(int)));

  hbox->addStretch(1);

  layout->addSpacing(16);

  layout->addWidget(addField(this, "ProcessorView::type"));
  setFieldName("ProcessorView::type", i18n("CPU type:"));

  layout->addWidget(addField(this, "ProcessorView::speed"));
  setFieldName("ProcessorView::speed", i18n("CPU speed:"));

  layout->addWidget(addField(this, "ProcessorView::cache"));
  setFieldName("ProcessorView::cache", i18n("Cache:"));

  layout->addWidget(addField(this, "ProcessorView::bogoMIPS"));
  setFieldName("ProcessorView::bogoMIPS", i18n("BogoMIPS:"));

  layout->addStretch(1);

  hbox = new QHBoxLayout(layout);

  hbox->addStretch(1);

  KPushButton *refreshButton = new KPushButton(i18n("&Refresh"), this, "ProcessorView::refresh_button");
  refreshButton->installEventFilter(this);
  hbox->addWidget(refreshButton);
  connect(refreshButton, SIGNAL(clicked()), this, SLOT(handleRefresh()));

  updateContent(false);
}

ProcessorView::~ProcessorView()
{
}

void ProcessorView::updateContent(bool force)
{
  // optimization: do not update if this is not the visible widget
  const QWidgetStack *views = (QWidgetStack *) this->parent();
  if(views->visibleWidget() != this && !force) return;

  SetiClientMonitor *monitor = kdoc->setiMonitor();
  const sys_info *info = (monitor != NULL) ? monitor->sysInfo() : NULL;
  const int cpu = (monitor != NULL) ? monitor->currentCPU() : 0;

  KComboBox *cpuMenu = (KComboBox *) child("ProcessorView::cpu_menu", "KComboBox");
  cpuMenu->clear();

  KLocale *locale = KGlobal::locale();

  if(info != NULL)
  {
    for(uint i = 0; i < info->cpus.count(); i++)
      cpuMenu->insertItem(i18n("CPU %1").arg(i+1));

    cpuMenu->setCurrentItem(cpu);

    if(!info->cpus[cpu].model.name.isEmpty())
      setFieldContentText("ProcessorView::type", i18n("%1 processor").arg(info->cpus[cpu].model.name));
    else
      setFieldContentText("ProcessorView::type", i18n(unknownContent));

    if(info->cpus[cpu].MHz > 0.0)
      setFieldContentText("ProcessorView::speed",
                          i18n("%1 MHz").arg(locale->formatNumber(info->cpus[cpu].MHz, 2)));
    else
      setFieldContentText("ProcessorView::speed", i18n(unknownContent));

    if(info->cpus[cpu].cacheSize >= 0)
      setFieldContentText("ProcessorView::cache",
                        i18n("%1 on CPU or CPU module").arg(SysInfoMonitor::kbToString(info->cpus[cpu].cacheSize)));
    else
      setFieldContentText("ProcessorView::cache", i18n(unknownContent));

    if(info->cpus[cpu].bogoMIPS > 0.0)
      setFieldContentText("ProcessorView::bogoMIPS", locale->formatNumber(info->cpus[cpu].bogoMIPS, 2));
    else
      setFieldContentText("ProcessorView::bogoMIPS", i18n(unknownContent));
  }
  else
  {
    setFieldContentText("ProcessorView::type", i18n(unknownContent));
    setFieldContentText("ProcessorView::speed", i18n(unknownContent));
    setFieldContentText("ProcessorView::cache", i18n(unknownContent));
    setFieldContentText("ProcessorView::bogoMIPS", i18n(unknownContent));
  }
}

void ProcessorView::handleRefresh()
{
  SetiClientMonitor *monitor = kdoc->setiMonitor();
  if(monitor != NULL) monitor->updateSysInfo();
}

void ProcessorView::handleMenuActivated(int index)
{
  SetiClientMonitor *monitor = kdoc->setiMonitor();
  if(monitor != NULL) monitor->setCurrentCPU(index);
}

#include "processorview.moc"

