/***************************************************************************
                          performanceitem.h  -  description
                             -------------------
    begin                : Sat Jun 9 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PERFORMANCEITEM_H
#define PERFORMANCEITEM_H

#include <qlistview.h>
#include <qstring.h>

const int N_COEFF = 3;

typedef struct {
  QString name, cache;
  double min, max, coeff[N_COEFF];
} performanceItemStruct;

class PerformanceItem : public QListViewItem  {
  public:
    PerformanceItem(QListView *parent, const performanceItemStruct& data);
    ~PerformanceItem();
    virtual QString key(int column, bool ascending) const;
    void setMultiplier(double multiplier);
  protected:
    virtual double computeCpF();
    performanceItemStruct data;
    double multiplier;
  private:
    QString cacheToKey(QString cache) const;
    QString CpFToKey(double CpF) const;
    double CpF;
};

#endif
