/***************************************************************************
                          logitem.cpp  -  description
                             -------------------
    begin                : Mon Aug 6 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kglobal.h>
#include <klocale.h>

#include "seticlientmonitor.h"

#include "logitem.h"

LogItem::LogItem(QListView *parent, const log_data& data)
        : QListViewItem(parent)
{
  this->data = data;

  KLocale *locale = KGlobal::locale();

  setText(0, locale->formatDateTime(data.done));
  setText(1, data.name);
  setText(2, SetiDataMonitor::raToString(data.start.ra));
  setText(3, SetiDataMonitor::decToString(data.start.dec));
  setText(4, QString("%1").arg(locale->formatNumber(data.angle_range, 3)));
  setText(5, locale->formatNumber(data.teraFLOPs, 3));
  setText(6, SetiClientMonitor::timeToString(data.cpu));
  setText(7, QString("%1%").arg(locale->formatNumber(data.progress * 1e2, 2)));
  setText(8, QString::number(data.spikes.returned));
  setText(9, locale->formatNumber(data.spikes.best_score, 3));
  setText(10, QString::number(data.gaussians.returned));
  setText(11, locale->formatNumber(data.gaussians.best_score, 3));
  setText(12, QString::number(data.pulses.returned));
  setText(13, locale->formatNumber(data.pulses.best_score, 3));
  setText(14, QString::number(data.triplets.returned));
  setText(15, locale->formatNumber(data.triplets.best_score, 3));
}

LogItem::~LogItem()
{
}

QString LogItem::key(int column, bool ascending) const
{
  const QDateTime epoch(QDate(1980, 1, 1));
  QString out;

  switch(column) {
    case 0:
      return(out.sprintf("%09d", epoch.secsTo(data.done)));
    case 1:
      return(data.name);
    case 2:
      return(out.sprintf("%05.0f", data.start.ra * 1e3));
    case 3:
      return(out.sprintf("%05.0f", data.start.dec * 1e3));
    case 4:
      return(out.sprintf("%05.0f", data.angle_range * 1e3));
    case 5:
      return(out.sprintf("%05.0f", data.teraFLOPs * 1e3));
    case 6:
      return(out.sprintf("%08.0f", data.cpu));
    case 7:
      return(out.sprintf("%07.0f", data.progress * 1e6));
    case 8:
      return(out.sprintf("%05d", data.spikes.returned));
    case 9:
      return(out.sprintf("%09.0f", data.spikes.best_score * 1e2));
    case 10:
      return(out.sprintf("%05d", data.gaussians.returned));
    case 11:
      return(out.sprintf("%09.0f", data.gaussians.best_score * 1e2));
    case 12:
      return(out.sprintf("%05d", data.pulses.returned));
    case 13:
      return(out.sprintf("%09.0f", data.pulses.best_score * 1e2));
    case 14:
      return(out.sprintf("%05d", data.triplets.returned));
    case 15:
      return(out.sprintf("%09.0f", data.triplets.best_score * 1e2));
    default:
      return(QListViewItem::key(column, ascending));
  }

  return(QString::null);
}

