/***************************************************************************
                          intervalwidget.h  -  description
                             -------------------
    begin                : Sat Jan 26 2002
    copyright            : (C) 2002 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INTERVALWIDGET_H
#define INTERVALWIDGET_H

#include <qwidget.h>

#include "intervalselectorwidget.h"

class IntervalWidget : public QWidget {
  Q_OBJECT
  public:
    IntervalWidget(IntervalSelectorWidget *selector=0, const char *name=0);
    virtual ~IntervalWidget();
    virtual int getType() const;
  public slots:
    virtual void setType(int type);
  protected:
    virtual void paintEvent(QPaintEvent *);
    virtual void mouseDoubleClickEvent(QMouseEvent *e);
    virtual void mousePressEvent(QMouseEvent *e);
    virtual void mouseReleaseEvent(QMouseEvent *e);
    virtual void mouseMoveEvent(QMouseEvent *e);
  private:
    void drawLeftHandle(const QPoint& topLeft, const QColor& color);
    void drawRightHandle(const QPoint& topRight, const QColor& color);
    void adjustSize(const QPoint& coord);
    int type;
    enum ResizeType {None, LeftHandle, RightHandle} resize;
    IntervalSelectorWidget *selector;
    int minX, maxX, minSize;
  private slots:
    void setupPopup();
    void handlePopup(int item);
};

#endif
