/***************************************************************************
                          intervalwidget.cpp  -  description
                             -------------------
    begin                : Sat Jan 26 2002
    copyright            : (C) 2002 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qdatetime.h>
#include <qpainter.h>
#include <qpopupmenu.h>
#include <qtooltip.h>

#include <klocale.h>

#include "intervalselectorwidget.h"

#include "intervalwidget.h"

const int HandleThickness = 4;

const QColor HandleNormalColor =  QColor(128, 128, 128);
const QColor HandleResizeColor = QColor(255, 0, 0);

const QColor IntervalColors[] = {QColor(75, 119, 172),
                                 QColor(224, 188, 56),
                                 QColor(0, 153, 0)};

IntervalWidget::IntervalWidget(IntervalSelectorWidget *selector, const char *name)
               : QWidget(selector, name), selector(selector)
{
  type = intervalStruct::Both;
  resize = None;

  QPopupMenu *popup = new QPopupMenu(this, "IntervalSelector::popup");
  popup->insertItem(i18n("&Download new WUs"), intervalStruct::Download);
  popup->insertItem(i18n("&Upload results"), intervalStruct::Upload);
  popup->setCheckable(true);
  connect(popup, SIGNAL(aboutToShow()), this, SLOT(setupPopup()));
  connect(popup, SIGNAL(activated(int)), this, SLOT(handlePopup(int)));
}

IntervalWidget::~IntervalWidget()
{
}

int IntervalWidget::getType() const
{
  return(type);
}

void IntervalWidget::setType(int type)
{
  this->type = type;
  repaint();
}

void IntervalWidget::paintEvent(QPaintEvent *)
{
  const QRect r = this->rect();
  QPoint topLeft(r.left(), 1), topRight(r.right(), 1);

  QPainter painter(this);
  painter.fillRect(r, white);
  painter.setPen(IntervalColors[type-1]);
  painter.drawLine(topLeft, topRight);
  topLeft.ry()--; topRight.ry()--;
  painter.drawLine(topLeft, topRight);

  drawLeftHandle(topLeft, resize == LeftHandle ? HandleResizeColor : HandleNormalColor);
  drawRightHandle(topRight, resize == RightHandle ? HandleResizeColor : HandleNormalColor);
}

void IntervalWidget::mouseDoubleClickEvent(QMouseEvent *e)
{
  const QRect r = this->rect();
  const QPoint p = e->pos();

  if(p.x() >= HandleThickness && p.x() <= r.right() - HandleThickness)
    selector->removeInterval(this);
}

void IntervalWidget::mousePressEvent(QMouseEvent *e)
{
  if (e->button() == RightButton) {
    QPopupMenu *popup = (QPopupMenu *) child("IntervalSelector::popup", "QPopupMenu");

    popup->popup(mapToGlobal(e->pos()));
  } else {
    const QRect r = this->geometry();
    const QPoint p = mapToParent(e->pos());

    if(p.x() >= r.left() && p.x() < r.left() + HandleThickness) {
      resize = LeftHandle;
      minX = selector->getMinX(p.x());
    } else if(p.x() <= r.right() && p.x() > r.right() - HandleThickness) {
      resize = RightHandle;
      maxX = selector->getMaxX(p.x());
    }
    minSize = selector->getMinSize();
    adjustSize(p);
  }
}

void IntervalWidget::mouseReleaseEvent(QMouseEvent *e)
{
  adjustSize(mapToParent(e->pos()));
  resize = None;
  repaint();
}

void IntervalWidget::mouseMoveEvent(QMouseEvent *e)
{
  adjustSize(mapToParent(e->pos()));
}

void IntervalWidget::drawLeftHandle(const QPoint& topLeft, const QColor& color)
{
  QPainter painter(this);
  QPointArray a(4);

  a[0] = QPoint(topLeft.x(), topLeft.y());
  a[1] = QPoint(topLeft.x() + HandleThickness, topLeft.y() + HandleThickness);
  a[2] = QPoint(topLeft.x() + HandleThickness, topLeft.y() + 3*HandleThickness);
  a[3] = QPoint(topLeft.x(), topLeft.y() + 3*HandleThickness);

  painter.setPen(black);
  painter.setBrush(color);
  painter.drawPolygon(a);
}

void IntervalWidget::drawRightHandle(const QPoint& topRight, const QColor& color)
{
  QPainter painter(this);
  QPointArray a(4);

  a[0] = QPoint(topRight.x(), topRight.y());
  a[1] = QPoint(topRight.x() - HandleThickness, topRight.y() + HandleThickness);
  a[2] = QPoint(topRight.x() - HandleThickness, topRight.y() + 3*HandleThickness);
  a[3] = QPoint(topRight.x(), topRight.y() + 3*HandleThickness);

  painter.setPen(black);
  painter.setBrush(color);
  painter.drawPolygon(a);
}

void IntervalWidget::setupPopup()
{
  QPopupMenu *popup = (QPopupMenu *) child("IntervalSelector::popup", "QPopupMenu");

  for(int i = intervalStruct::Download; i < intervalStruct::Both; i++)
    popup->setItemChecked(i, type & i);
}

void IntervalWidget::handlePopup(int item)
{
  if(item == intervalStruct::Download)
    if(type & intervalStruct::Download)
      type = intervalStruct::Type(type & intervalStruct::Upload);
    else
      type = intervalStruct::Type(type | intervalStruct::Download);
  else
    if(type & intervalStruct::Upload)
      type = intervalStruct::Type(type & intervalStruct::Download);
    else
      type = intervalStruct::Type(type | intervalStruct::Upload);

  if(type == 0)
    selector->removeInterval(this);
  else
    repaint();
}

#define min(_a, _b) ((_a) < (_b) ? (_a) : (_b))
#define max(_a, _b) ((_a) > (_b) ? (_a) : (_b))
void IntervalWidget::adjustSize(const QPoint& pos)
{
  if(resize == None)
    return;

  QRect r = this->geometry();

  if(resize == LeftHandle)
    r.setLeft(min(max(pos.x(), minX), r.right()-minSize+1));
  else /* resize == LeftHandle */
    r.setRight(max(min(pos.x(), maxX), r.left()+minSize-1));
  this->setGeometry(r);
}

#include "intervalwidget.moc"

